<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor artelligence-testimonial Widget.
 *
 * Elementor widget that uses the artelligence-testimonial control.
 *
 * @since 1.0.0
 */
class Elementor_artelligence_Testimonial_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve artelligence-testimonial widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'artelligence-testimonial';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve artelligence-testimonial widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Artellignce Testimonial v2', 'elementor-artelligence-testimonial-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve artelligence-testimonial widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-carousel-loop';
	}

	/**
	 * Register artelligence-testimonial widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-artelligence-testimonial-control' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'list_content', [
				'label' => __( 'Content', 'elementor-artelligence-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( 'Beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas aspernatur aut odit aut fugit, sed. Beatae vitae dicta ripiscing elit, sed do euismod tempor incidunt. Labore et dolore magna aliqua ut enim ad minim adipiscing elit, sed do euismod tempor incidunt ut labore.' , 'elementor-artelligence-testimonial-control' ),
				'label_block' => true,
				'show_label' => false,
			]
		);
		$repeater->add_control(
			'list_username', [
				'label' => __( 'User Name', 'elementor-artelligence-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'User Name' , 'elementor-artelligence-testimonial-control' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'list_designation', [
				'label' => __( 'Designation', 'elementor-artelligence-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Separtment' , 'elementor-artelligence-testimonial-control' ),
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'list_image',
			[
				'label' => esc_html__( 'User Image', 'elementor-farosa-04-control' ),
				'label_block' => true,
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => PLUGIN_BASE_URI. 'assets/img/testimonial-user-img.png' ,
				],
			]
		);
		$this->add_control(
			'list',
			[
				'label' => __( 'Repeater List', 'elementor-artelligence-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_content' => __( 'Content', 'elementor-artelligence-testimonial-control' ),
						'list_username' => __( 'User Name', 'elementor-artelligence-testimonial-control' ),
						'list_designation' => __( 'Designation Name', 'elementor-artelligence-testimonial-control' ),
						'list_image' => __( 'User Image', 'elementor-artelligence-testimonial-control' ),
					],
					[
						'list_content' => __( 'Content', 'elementor-artelligence-testimonial-control' ),
						'list_username' => __( 'User Name', 'elementor-artelligence-testimonial-control' ),
						'list_designation' => __( 'Designation Name', 'elementor-artelligence-testimonial-control' ),
						'list_image' => __( 'User Image', 'elementor-artelligence-testimonial-control' ),
					],
				],
				'heading_field' => '{{{ list_heading }}}',
			]
		);
		
		
        $this->end_controls_section();
		////////////////////////////////////////////////  Container Style Start /////////////////////////////////////////////////
		$this->start_controls_section(
			'container_style_section',
			[
				'label' => esc_html__( 'Container Style', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $slider_style = array('style 1','style 2');
		$slider_style = array_combine( $slider_style, $slider_style );
		$this->add_control(
			'artelligence_testimonial_style',
			[
				'label' => esc_html__( 'Testimonial Style', 'artelligence_testimonial' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'Default', 'artelligence_testimonial' ),
				] + $slider_style,
			]
		);
		$this->add_responsive_control(
			'container_padding',
			[
				'label' => __( 'Padding', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .artelligence-testimonial-section .artelligence-testimonial-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_control(
            'container_alignment',
            [
                'label' => esc_html__('Alignment', 'textdomain'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'textdomain'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'textdomain'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'textdomain'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .artelligence-testimonial-section .artelligence-testimonial-box' => 'text-align: {{VALUE}};',
                ],
            ]
        );
		$this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'label' => __( 'Border', 'textdomain' ),
                'selector' => '{{WRAPPER}} .artelligence-testimonial-section .artelligence-testimonial-box',
            ]
        );
        $this->add_responsive_control(
			'container_borderbox_radius',
			[
				'label' => __( 'Border Radius', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .artelligence-testimonial-section .artelligence-testimonial-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'container_background',
				'label' => __( 'Background', 'textdomain' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .artelligence-testimonial-section .artelligence-testimonial-box',
            ]
        );  
		$this->add_responsive_control(
			'artelligence_testimonial_space',
			[
				'label' => esc_html__( 'Spacing Between', 'artelligence_testimonial' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
			]
		);

		$slides_to_show = range( 1, 5 );
		$slides_to_show = array_combine( $slides_to_show, $slides_to_show );

		$this->add_responsive_control(
			'artelligence_slides_to_show',
			[
				'label' => esc_html__( 'Slides to Show', 'artelligence_slides' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'Default', 'artelligence_slides' ),
				] + $slides_to_show,
				'default' => '2',
				
			]
		);
		$this->add_responsive_control(
			'artelligence_show_nav',
			[
				'label' => esc_html__( 'Show Nav', 'artelligence_slides_nav' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'true' => esc_html__( 'Yes', 'artelligence_slides' ),
					'false' => esc_html__( 'No', 'artelligence_slides' ),
				],
				'default' => 'false',
			]
		);
		$this->add_responsive_control(
			'artelligence_show_dots',
			[
				'label' => esc_html__( 'Show Dots', 'artelligence_slides_dots' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'true' => esc_html__( 'Yes', 'artelligence_slides' ),
					'false' => esc_html__( 'No', 'artelligence_slides' ),
				],
				'default' => 'true',
			]
		);
		

        $this->end_controls_section(); 
		////////////////////////////////////////////////  Conatiner Style Ends /////////////////////////////////////////////////
		////////////////////////////////////////////////  Description Style Ends ///////////////////////////////////////////////// 
        $this->start_controls_section(
			'desc_style_section',
			[
				'label' => esc_html__( 'Description Style', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'desc_typography',
				'label' => __( 'Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .artelligence-testimonial-section .artelligence-testimonial-box-content p',
			]
		);
        $this->add_control(
            'description_color',
            [
                'label' => esc_html__('Color', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .artelligence-testimonial-section .artelligence-testimonial-box-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_responsive_control(
			'desc_margin',
			[
				'label' => __( 'Margin', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .artelligence-testimonial-section .artelligence-testimonial-box-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	
		$this->add_responsive_control(
			'desc_padding',
			[
				'label' => __( 'Padding', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .artelligence-testimonial-section .artelligence-testimonial-box-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'client_style_section',
			[
				'label' => esc_html__( 'Author', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
            'client_color',
            [
                'label' => esc_html__('Color', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .artelligence-testimonial-section .user-name' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'client_typography_button',
				'label' => __( 'Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .artelligence-testimonial-section .user-name',
			]
		);
        $this->add_responsive_control(
			'client_margin',
			[
				'label' => __( 'Margin', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .artelligence-testimonial-section .user-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	
		$this->add_responsive_control(
			'client_padding',
			[
				'label' => __( 'Padding', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .artelligence-testimonial-section .user-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'image_borderbox_radius',
			[
				'label' => __( 'Image Radius', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .artelligence-testimonial-section .artelligence-testimonial-box .user-content-outer figure img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
            'style5_section',
            [
                'label' => esc_html__( 'Designation Style', 'textdomain' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'depart_color',
            [
                'label' => esc_html__('Color', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .artelligence-testimonial-section .designation' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'designation_typography_button',
				'label' => __( 'Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .artelligence-testimonial-section .designation',
			]
		);
		$this->add_responsive_control(
			'depart_padding',
			[
				'label' => __( 'Padding', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .artelligence-testimonial-section .designation' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section();
		////////////////////////////////////////////////  Icon Style Start /////////////////////////////////////////////////
		
        $this->start_controls_section(
			
			'artelligence_icon_style_section',
			[
				'label' => esc_html__( ' Icon Style', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'artelligence_icon_Size',
			[
				'label' => esc_html__( 'Size', 'artelligence_icon' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .artelligence-testimonial-section ul li i' => 'font-size: {{SIZE}}{{UNIT}}',
				],
			]
		);
	
		$this->add_control(
			'artelligence_icon_color',
			[
				'label' => __( ' Icon Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .artelligence-testimonial-section ul li i' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'artelligence_icon_space',
			[
				'label' => esc_html__( 'Icon Spacing', 'elementor' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .artelligence-testimonial-section ul li i' => 'margin-right: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
        $this->add_responsive_control(
			'artelligence_icon_margin',
			[
				'label' => __( 'Margin', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .artelligence-testimonial-section ul' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'testimonial_flexbox_section',
			[
				'label' => esc_html__('Testimonial Flexbox', 'elementor-blog-post-control'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'testimonial_display',
			[
				'label' => esc_html__('Display', 'elementor-blog-post-control'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'flex',
				'options' => [
					'flex' => 'Flex',
					'block' => 'Block',
					'inline' => 'Inline',
					'inline-block' => 'Inline Block',
				],
				'selectors' => [
					'{{WRAPPER}} .artelligence-testimonial-box' => 'display: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'testimonial_justify_content',
			[
				'label' => esc_html__('Justify Content', 'elementor-blog-post-control'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'left',
				'options' => [
					'flex-start' => 'Flex Start',
					'flex-end' => 'Flex End',
					'center' => 'Center',
					'space-between' => 'Space Between',
					'space-around' => 'Space Around',
					'space-evenly' => 'Space Evenly',
				],
				'selectors' => [
					'{{WRAPPER}} .artelligence-testimonial-box' => 'justify-content: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'testimonial_align_items',
			[
				'label' => esc_html__('Align Items', 'elementor-blog-post-control'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'left',
				'options' => [
					'stretch' => 'Stretch',
					'flex-start' => 'Flex Start',
					'flex-end' => 'Flex End',
					'center' => 'Center',
					'baseline' => 'Baseline',
				],
				'selectors' => [
					'{{WRAPPER}} .artelligence-testimonial-box' => 'align-items: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'testimonial_flex_direction',
			[
				'label' => esc_html__('Flex Direction', 'elementor-blog-post-control'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'column',
				'options' => [
					'row' => 'Row',
					'row-reverse' => 'Row Reverse',
					'column' => 'Column',
					'column-reverse' => 'Column Reverse',
				],
				'selectors' => [
					'{{WRAPPER}} .artelligence-testimonial-box' => 'flex-direction: {{VALUE}};',
				],
			]
		);
		
		
		$this->end_controls_section();
		$this->start_controls_section(
            'dots_section',
            [
                'label' => esc_html__( 'Dots Style', 'elementor-services-box-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
		$this->add_control(
            'dots_color',
            [
                'label' => esc_html__('Color', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot.active span' => 'background: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
			'custom_width1',
			[
				'label' => esc_html__('Normal Width', 'your-text-domain'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .owl-carousel .owl-dots .owl-dot span' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'custom_width',
			[
				'label' => esc_html__('Active Custom Width', 'your-text-domain'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .owl-carousel .owl-dots .owl-dot.active span' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'testimonial_dots_align',
			[
				'label' => esc_html__('Dots Align', 'elementor-blog-post-control'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'left',
				'options' => [
					'left' => 'Left',
					'center' => 'Center',
					'right' => 'Right',
					'justify' => 'Justify',
				],
				'selectors' => [
					'{{WRAPPER}} .artelligence-testimonial-section .owl-carousel .owl-dots' => 'text-align: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_section();

		////////////////////////////////////////////////  Icon Style Ends /////////////////////////////////////////////////

	}


	/**
	 * Render artelligence-testimonial widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
			if($settings['artelligence_testimonial_style'] == "style 1" || $settings['artelligence_testimonial_style'] == "Default" || $settings['artelligence_testimonial_style'] == ""){
				?>
				
				<section class="artelligence-testimonial-section position-relative">
					<div class="position-relative" data-aos="fade-up">
						<div class="owl-carousel owl-theme">
							<?php
								$count = 0;
								if ( $settings['list'] ) {
								foreach ( $settings['list'] as $item ) {	
							?>
							<div class="item">
								<div class="artelligence-testimonial-box">
									<div class="user-content-outer d-flex align-items-center justify-content-between">
										<div class="user-content-outer-inner d-flex align-items-center">
											<figure class="mb-0">
												<?php
													if( isset($item['list_image']['id']) && !empty( $item['list_image']['id'] ) ){
												?>
												<?php echo wp_get_attachment_image( $item['list_image']['id'], 'full' ); ?>
												<?php
												}
												else {
												?>
													<img class="img-fluid" src="<?php echo PLUGIN_BASE_URI. 'assets/img/testimonial-user-img.png'?>" alt="">
												<?php
													}
												?>
											</figure>
											<div class="user-content">
												<h6 class="user-name"><?php echo $item['list_username']; ?></h6>
												<span class="designation"><?php echo $item['list_designation']; ?></span>
											</div>
										</div>	
										<div class="quote-icon">
											<figure class="mb-0"><img class="img-fluid" src="<?php echo PLUGIN_BASE_URI . 'assets/img/testimonial-quote-img.png' ?>" alt=""></figure>
										</div>
									</div>	
									<div class="artelligence-testimonial-box-content">
										<p class="content"><?php echo $item['list_content'];?></p>
										<ul class="artelligence-rating list-unstyled mb-0">
											<li><i class="fa-solid fa-star"></i></li>
											<li><i class="fa-solid fa-star"></i></li>
											<li><i class="fa-solid fa-star"></i></li>
											<li><i class="fa-solid fa-star"></i></li>
											<li><i class="fa-solid fa-star"></i></li>
										</ul>
									</div>
								</div>
							</div>
							
								<?php
									$count++;
								}
								}
								?>
						</div>
					</div>
				</section> 
				<?php
			}
			else if($settings['artelligence_testimonial_style'] == "style 2"){
				?>
				
				<section class="artelligence-testimonial-section artelligence-testimonial-section2 position-relative">
					<div class="position-relative" data-aos="fade-up">
						<div class="owl-carousel owl-theme">
							<?php
								$count = 0;
								if ( $settings['list'] ) {
								foreach ( $settings['list'] as $item ) {	
							?>
							<div class="item">
								<div class="artelligence-testimonial-box">
									<div class="artelligence-testimonial-box-content">
										<p class="content"><?php echo $item['list_content'];?></p>
									</div>
									<div class="user-content-outer d-flex align-items-center justify-content-between">
										<div class="user-content-outer-inner d-flex align-items-center">
											<figure class="mb-0">
												<?php
													if( isset($item['list_image']['id']) && !empty( $item['list_image']['id'] ) ){
												?>
												<?php echo wp_get_attachment_image( $item['list_image']['id'], 'full' ); ?>
												<?php
												}
												else {
												?>
													<img class="img-fluid" src="<?php echo PLUGIN_BASE_URI. 'assets/img/testimonial-user-img.png'?>" alt="">
												<?php
													}
												?>
											</figure>
											<div class="user-content">
												<h6 class="user-name"><?php echo $item['list_username']; ?></h6>
												<span class="designation"><?php echo $item['list_designation']; ?></span>
												<div>
												<ul class="artelligence-rating2 list-unstyled mb-0">
													<li><i class="fa-solid fa-star"></i></li>
													<li><i class="fa-solid fa-star"></i></li>
													<li><i class="fa-solid fa-star"></i></li>
													<li><i class="fa-solid fa-star"></i></li>
													<li><i class="fa-solid fa-star"></i></li>
												</ul>
												</div>
											</div>
										</div>	
									</div>	
									
								</div>
							</div>
							
								<?php
									$count++;
								}
								}
								?>
						</div>
					</div>
				</section> 
				<?php
			}
			
			?>
				<script>
					var testimonial_settings= <?php echo json_encode($settings); ?>;
				</script>
			<?php
				
	}
	

}
