<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor testimonial Widget.
 *
 * Elementor widget that uses the testimonial control.
 *
 * @since 1.0.0
 */
class Elementor_Testimonial_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve testimonial widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'testimonial';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve testimonial widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Artelligence Testimonial', 'elementor-testimonial-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve testimonial widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-carousel-loop';
	}

	/**
	 * Register testimonial widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-testimonial-control' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'list_clientname', [
				'label' => __( 'clientname', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'clientname' , 'elementor-testimonial-control' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'list_content', [
				'label' => __( '“Quisquam est, qui dolorem ipsum quia dolor sit amet conse aetur, adipisci velit, sed ruia non numquam eius modi temor incidunt ut labore et dolore magnam alieuam zuaerat voluta tem nostrum exercitationem”', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( '“Quisquam est, qui dolorem ipsum quia dolor sit amet conse aetur, adipisci velit, sed ruia non numquam eius modi temor incidunt ut labore et dolore magnam alieuam zuaerat voluta tem nostrum exercitationem”' , 'elementor-testimonial-control' ),
				'label_block' => true,
				'show_label' => false,
			]
		);
		$repeater->add_control(
			'list_department',
			[
				'label' => esc_html__( 'client Department', 'elementor-testimonial-control' ),
				'label_block' => true,
				'placeholder' => __( 'Hr', 'elementor-testimonial-control' ),
				'default' => __( 'Hr' , 'elementor-testimonial-control' ),
				'type' => 'text',
			]
		);
		$repeater->add_control(
			'list_image',
			[
				'label' => esc_html__( 'Client image', 'elementor-testimonial-04-control' ),
				'label_block' => true,
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => PLUGIN_BASE_URI. 'assets/images/testimonial-image.png' ,
				],
			]
		);
        $repeater->add_control(
			'list_image1',
			[
				'label' => esc_html__( 'Quote Icon', 'elementor-testimonial-04-control' ),
				'label_block' => true,
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => PLUGIN_BASE_URI. 'assets/images/testimonial-comas.png' ,
				],
			]
		);
		$this->add_control(
			'list',
			[
				'label' => __( 'Repeater List', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						
						'list_clientname' => __( 'Client Name', 'elementor-testimonial-control' ),
						'list_content' => __( '“Quisquam est, qui dolorem ipsum quia dolor sit amet conse aetur, adipisci velit, sed ruia non numquam eius modi temor incidunt ut labore et dolore magnam alieuam zuaerat voluta tem nostrum exercitationem”', 'elementor-testimonial-control' ),
						'list_department' => __( 'Department Name', 'elementor-testimonial-control' ),
						'list_image' => __( 'image', 'elementor-testimonial-control' ),
                        'list_image1' => __( 'image1', 'elementor-testimonial-control' ),
					],
					[
						
						'list_clientname' => __( 'Client Name', 'elementor-testimonial-control' ),
						'list_content' => __( '“Quisquam est, qui dolorem ipsum quia dolor sit amet conse aetur, adipisci velit, sed ruia non numquam eius modi temor incidunt ut labore et dolore magnam alieuam zuaerat voluta tem nostrum exercitationem”', 'elementor-testimonial-control' ),
						'list_department' => __( 'Department Name', 'elementor-testimonial-control' ),
						'list_image' => __( 'image', 'elementor-testimonial-control' ),
                        'list_image1' => __( 'image1', 'elementor-testimonial-control' ),

					],
				],
				'heading_field' => '{{{ list_heading }}}',
			]
		);
		$this->end_controls_section();
		//Color Control
		$this->start_controls_section(
			'color_section',
			[
				'label' => esc_html__( 'Color', 'elementor-testimonial-control' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'text_color_content',
			[
				'label' => esc_html__( 'Content Color', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'label' => __( 'Text Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .testimonial-section p',
			]
		);
		$this->add_responsive_control(
			'text_align',
			[
				'label' => esc_html__( 'Alignment', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'elementor-testimonial-control' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'elementor-testimonial-control' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'elementor-testimonial-control' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} p'   => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'text_color1',
			[
				'label' => esc_html__( 'Client Name Color', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .text-size-18' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'name_typography',
				'label' => __( 'Client Name Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .testimonial-section .testimonial_content .text-size-18',
			]
		);
		$this->add_responsive_control(
			'text_align1',
			[
				'label' => esc_html__( 'Alignment', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'elementor-testimonial-control' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'elementor-testimonial-control' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'elementor-testimonial-control' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .text-size-18'   => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'text_color2',
			[
				'label' => esc_html__( 'Department Name Color', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .text-size-16' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'department_typography',
				'label' => __( 'Department Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .testimonial-section .testimonial_content span',
			]
		);
		$this->add_responsive_control(
			'text_align2',
			[
				'label' => esc_html__( 'Alignment', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'elementor-testimonial-control' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'elementor-testimonial-control' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'elementor-testimonial-control' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .text-size-16'   => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'image_radius',
			[
				'label' => esc_html__( 'Image Radius', 'elementor' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .testimonial-section .testimonial-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border1',
                'label' => __( 'Border', 'textdomain' ),
                'selector' => '{{WRAPPER}} .testimonial-section .testimonial-image img',
            ]
        );
        
        $this->add_control(
            'borde1r_color1',
            [
                'label' => __( 'Border Color', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-section .testimonial-image img' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'border!' => '',
                ],
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background1',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .testimonial-section .testimonial_content .content-box .box',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .testimonial-section .testimonial_content .content-box',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background_arrows',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} #home-7-testimonial .testimonial-section #TestimonialCrouselControl .carousel-control-next:hover, {{WRAPPER}} #home-7-testimonial .testimonial-section #TestimonialCrouselControl .carousel-control-prev:hover',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'border_style_section',
			[
				'label' => esc_html__( 'Border Style', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'label' => __( 'Border', 'textdomain' ),
                'selector' => '{{WRAPPER}} .testimonial-section .testimonial_content .content-box',
            ]
        );
        
        $this->add_control(
            'borde1r_color',
            [
                'label' => __( 'Border Color', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-section .testimonial_content .content-box' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'border!' => '',
                ],
            ]
        );       
        $this->end_controls_section(); 
	}


	/**
	 * Render testimonial widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
		<section class="testimonial-section w-100 float-left d-table">
            <div class="container">
                <div id="TestimonialCrouselControl" class="carousel slide" data-ride="carousel">
                    <div class="carousel-inner">
						<?php
						$count = 0;
						if ( $settings['list'] ) {
						foreach ( $settings['list'] as $item ) {	
							?>
                        <div class="carousel-item <?php if($count==0){echo 'active';}?>">
                            <div class="testimonial_content">
                            <div class="content-box">
                                    <p class="h4"><?php echo $item['list_content']; ?></p>
                                    <figure class="testimonial-image mb-0">
										<?php
											if( isset($item['list_image']['id']) && !empty( $item['list_image']['id'] ) ){
										?>
                                        <?php echo wp_get_attachment_image( $item['list_image']['id'], 'full' ); ?>
										<?php
										}
										else {
										?>
											<img class="img-fluid" src="<?php echo PLUGIN_BASE_URI. 'assets/images/testimonial-image.png' ?>" alt="">
										<?php
											}
										?>
                                    </figure>
                                    <span class="text-size-18"><?php echo $item['list_clientname']; ?></span>
                                    <span class="text-size-16 mb-0"><?php echo $item['list_department']; ?></span>
                                    <div class="box">
                                        <figure class="testimonial-comas mb-0">
										<?php
											if( isset($item['list_image']['id']) && !empty( $item['list_image1']['id'] ) ){
										?>
                                        <?php echo wp_get_attachment_image( $item['list_image1']['id'], 'full' ); ?>
										<?php
										}
										else {
										?>
											<img src="<?php echo PLUGIN_BASE_URI. 'assets/images/testimonial-comas.png' ?>" alt="">
										<?php
											}
										?>
                                        </figure>
                                    </div>
                                </div>
                            </div>
                        </div>
						<?php
						$count++;
					}
					}
					?>
                    </div>
                    <div class="pagination-outer">
                        <a class="carousel-control-next" href="#TestimonialCrouselControl" role="button" data-slide="next">
                            <i class="fa-solid fa-angle-right"></i>
                            <span class="sr-only">Next</span>
                        </a>
                        <a class="carousel-control-prev" href="#TestimonialCrouselControl" role="button" data-slide="prev">
                            <i class="fa-solid fa-angle-left"></i>
                            <span class="sr-only">Previous</span>
                        </a>
                    </div>
                </div>
            </div>
    </section>
        <?php
	}

}