<?php
/** 
 * Artelligence Customizer data
 */

function artelligence_customizer( $data ) {
	$artelligence_elementor_template_list = artelligence_get_elementor_templates();
	$artelligence_elementor_header_templates = artelligence_get_elementor_header_templates();
	return array(
		'panel' => array ( 
			'id' => 'artelligence',
			'name' => esc_html__('Artelligence Customizer','artelligence'),
			'priority' => 10,
			'section' => array(
				'header_setting' => array(
					'name' => esc_html__( 'Header Topbar Setting', 'artelligence' ),
					'priority' => 10,
					'fields' => array(
						array(
							'name' => esc_html__( 'Topbar Swicher', 'artelligence' ),
							'id' => 'artelligence_topbar_switch',
							'default' => false,
							'type' => 'switch',
							'transport'	=> 'refresh'
						),						
						array(
							'name' => esc_html__( 'Show Button', 'artelligence' ),
							'id' => 'artelligence_show_header_btn',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Button Text', 'artelligence' ),
							'id' => 'artelligence_header_btn_text',
							'default' => esc_html__('Sign in','artelligence'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Button Link', 'artelligence' ),
							'id' => 'artelligence_header_btn_link',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),						
						array(
							'name' => esc_html__( 'Button Icon', 'artelligence' ),
							'id' => 'artelligence_header_btn_icon',
							'default' => esc_html__('fa fa-user-o', 'artelligence'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						/** investment button **/	
						array(
							'name' => esc_html__( 'Show Investment Offer Link', 'artelligence' ),
							'id' => 'artelligence_show_investment_offer_link',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Link Text', 'artelligence' ),
							'id' => 'artelligence_header_link_text',
							'default' => esc_html__('Artelligence Offer','artelligence'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Link Url', 'artelligence' ),
							'id' => 'artelligence_header_link_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						/** contact-info **/
						array(
							'name' => esc_html__( 'Show Contact Info', 'artelligence' ),
							'id' => 'artelligence_show_contact_info',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Email Address', 'artelligence' ),
							'id' => 'artelligence_header_email',
							'default' => esc_html__('info@gmail.com','artelligence'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Phone Number', 'artelligence' ),
							'id' => 'artelligence_header_phone',
							'default' => esc_html__('+97657945737', 'artelligence'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						)

					) 
				),
				'artelligence_topbar_social_profiles_setting' => array(
					'name' => esc_html__( 'Header Social Profiles', 'artelligence' ),
					'priority' => 15,
					'fields' => array(
						array(
							'name' => esc_html__( 'Show Social Profiles', 'artelligence' ),
							'id' => 'artelligence_show_social_profiles',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Facebook Url', 'artelligence' ),
							'id' => 'artelligence_topbar_fb_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Twitter Url', 'artelligence' ),
							'id' => 'artelligence_topbar_twitter_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Linkedin Url', 'artelligence' ),
							'id' => 'artelligence_topbar_linkedin_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Instagram Url', 'artelligence' ),
							'id' => 'artelligence_topbar_instagram_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
					) 
				),
				'header_main_setting' => array(
					'name' => esc_html__( 'Header Setting', 'artelligence' ),
					'priority' => 20,
					'fields' => array(
						array(
							'name' => esc_html__( 'Choose Header Style', 'artelligence' ),
							'id' => 'choose_default_header',
							'type'     => 'select',
							'choices'  => array(
								'header-style-1' => esc_html__( 'Header Style 1', 'artelligence' ),
								'header-style-2' => esc_html__( 'Header Style 2', 'artelligence' ),
							),
							'default' => 'header-style-2',
							'transport'	=> 'refresh'
						),
						array(
							'name' => esc_html__( 'Header Type', 'artelligence' ),
							'id' => 'choose_default_header',
							'type'     => 'select',
							'choices'  => array(
								'default-header' => esc_html__( 'Default Header', 'artelligence' ),
								'elementor-header' => esc_html__( 'Elementor Header', 'artelligence' ),
							),
							'default' => 'default-header',
							'transport'	=> 'refresh'
						),
						array(
							'name' => esc_html__( 'Header Elementor Templates', 'artelligence' ),
							'id' => 'choose_elementor_header',
							'type'     => 'select',
							'choices'  => $artelligence_elementor_header_templates,
							'transport'	=> 'refresh',
							'required' => ['header_source_type',
							'=',
							'e'],
						),
						array(
							'name' => esc_html__( 'Show Header Search', 'artelligence' ),
							'id' => 'artelligence_header_search_show',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),	
					) 
				),	
				'page_title_setting'=> array(
					'name'=> esc_html__('Page Title Setting','artelligence'),
					'priority'=> 30,
					'fields'=> array(
						array(
							'name' => esc_html__( 'Choose Breadcrumb Style', 'artelligence' ),
							'id' => 'choose_default_breadcrumb',
							'type'     => 'select',
							'choices'  => array(
								'breadcrumb-style-1' => esc_html__( 'Breadcrumb Style 1', 'artelligence' ),
								'breadcrumb-style-2' => esc_html__( 'default', 'artelligence' ),
							),
							'default' => 'breadcrumb-style-1',
							'transport'	=> 'refresh'
						),
						array(
							'name'=>esc_html__('Breadcrumb BG Color','artelligence'),
							'id'=>'breadcrumb_bg_color',
							'default'=> esc_html__('#343a40','artelligence'),
							'transport'	=> 'refresh'  
						),
						array(
							'name' => esc_html__( 'Page Title Background Image', 'artelligence' ),
							'id' => 'breadcrumb_bg_img',
							'default' => '',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Breadcrumb Archive', 'artelligence' ),
							'id' => 'breadcrumb_archive',
							'default' => esc_html__('Archive for category','artelligence'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Breadcrumb Search', 'artelligence' ),
							'id' => 'breadcrumb_search',
							'default' => esc_html__('Search results for','artelligence'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Breadcrumb tagged', 'artelligence' ),
							'id' => 'breadcrumb_post_tags',
							'default' => esc_html__('Posts tagged','artelligence'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),		
						array(
							'name' => esc_html__( 'Breadcrumb posted by', 'artelligence' ),
							'id' => 'breadcrumb_artitle_post_by',
							'default' => esc_html__('Articles posted by','artelligence'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),		
						array(
							'name' => esc_html__( 'Breadcrumb Page Not Found', 'artelligence' ),
							'id' => 'breadcrumb_404',
							'default' => esc_html__('Page Not Found','artelligence'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),		
						array(
							'name' => esc_html__( 'Breadcrumb Page', 'artelligence' ),
							'id' => 'breadcrumb_page',
							'default' => esc_html__('Page','artelligence'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),			
						array(
							'name' => esc_html__( 'Breadcrumb Shop', 'artelligence' ),
							'id' => 'breadcrumb_shop',
							'default' => esc_html__('Shop','artelligence'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),			
						array(
							'name' => esc_html__( 'Breadcrumb Home', 'artelligence' ),
							'id' => 'breadcrumb_home',
							'default' => esc_html__('Home','artelligence'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),					
					)
				),
				'blog_setting'=> array(
					'name'=> esc_html__('Blog Setting','artelligence'),
					'priority'=> 40,
					'fields'=> array(
						array(
							'name' => esc_html__( 'Show Blog BTN', 'artelligence' ),
							'id' => 'artelligence_blog_btn_switch',
							'default' => 1,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Show Blog Btn Icon', 'artelligence' ),
							'id' => 'artelligence_blog_btn_icon_switch',
							'default' => 1,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Blog Button text', 'artelligence' ),
							'id' => 'artelligence_blog_btn',
							'default' => esc_html__('Read More','artelligence'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),							
						array(
							'name' => esc_html__( 'Blog Button Icon', 'artelligence' ),
							'id' => 'artelligence_blog_btn_icon',
							'default' => esc_html__('fas fa-angle-double-right','artelligence'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),						
						array(
							'name' => esc_html__( 'Blog Title', 'artelligence' ),
							'id' => 'breadcrumb_blog_title',
							'default' => esc_html__('Blog','artelligence'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),						
						array(
							'name' => esc_html__( 'Blog Details Title', 'artelligence' ),
							'id' => 'breadcrumb_blog_title_details',
							'default' => esc_html__('Blog Details','artelligence'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),

					)
				),
				'artelligence_footer_setting' => array(
					'name'=> esc_html__('Footer Setting','artelligence'),
					'priority'=> 60,
					'fields'=> array(
						array(
							'name' => esc_html__( 'Footer Elementor Templates', 'artelligence' ),
							'id' => 'choose_elementor_footer',
							'type'     => 'select',
							'choices'  => $artelligence_elementor_template_list,
							'transport'	=> 'refresh',
							'required' => ['footer_source_type',
							'=',
							'e'],
						),
						array(
							'name' => esc_html__( 'Choose Footer Style', 'artelligence' ),
							'id' => 'choose_default_footer',
							'type'     => 'select',
							'choices'  => array(
								'footer-style-1' => esc_html__( 'Footer Style 1', 'artelligence' ),
								'footer-style-2' => esc_html__( 'Footer Style 2', 'artelligence' ),
								'footer-style-3' => esc_html__( 'Footer Style 3', 'artelligence' ),
							),
							'default' => 'footer-style-1',
							'transport'	=> 'refresh'
						),
						array(
							'name' => esc_html__( 'Footer Background Image', 'artelligence' ),
							'id' => 'artelligence_footer_bg',
							'default' => '',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name'=>esc_html__('Footer BG Color','artelligence'),
							'id'=>'artelligence_footer_bg_color',
							'default'=> esc_html__('#f4f9fc','artelligence'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Copy Right','artelligence'),
							'id'=>'artelligence_copyright',
							'default'=> esc_html__('Copyright &copy; Artelligence 2023. All rights reserved','artelligence'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						),	
						array(
							'name'=>esc_html__('Enable Scrollup','artelligence'),
							'id'=>'artelligence_scrollup_switch',
							'default'=> false,
							'type'=>'switch',
							'transport'	=> 'refresh'  
						),						
						array(
							'name'=>esc_html__('Enable Footer Widgets','artelligence'),
							'id'=>'artelligence_enable_footer_widgets',
							'default'=> true,
							'type'=>'switch',
							'transport'	=> 'refresh'  
						),	
						array(
							'name'=>esc_html__('Enable Preloader','artelligence'),
							'id'=>'artelligence_preloader_switch',
							'default'=> false,
							'type'=>'switch',
							'transport'	=> 'refresh'  
						)
					)
				),
				'error_page_setting'=> array(
					'name'=> esc_html__('404 Setting','artelligence'),
					'priority'=> 90,
					'fields'=> array(
						array(
							'name'=>esc_html__('400 Text','artelligence'),
							'id'=>'artelligence_error_404_text',
							'default'=> esc_html__('404','artelligence'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Not Found Title','artelligence'),
							'id'=>'artelligence_error_title',
							'default'=> esc_html__('Page not found','artelligence'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('404 Description Text','artelligence'),
							'id'=>'artelligence_error_desc',
							'default'=> esc_html__('Oops! The page you are looking for does not exist. It might have been moved or deleted','artelligence'),
							'type'=>'textarea',
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('404 Link Text','artelligence'),
							'id'=>'artelligence_error_link_text',
							'default'=> esc_html__('Back To Home','artelligence'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						)
						
					)
				),
			),
		)
	);

}

add_filter('artelligence_customizer_data', 'artelligence_customizer');


