<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor banner-sliders Widget.
 *
 * Elementor widget that uses the banner-sliders control.
 *
 * @since 1.0.0
 */
class Elementor_Banner_Sliders_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve banner-sliders widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'banner-sliders';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve banner-sliders widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Artelligence Banner slider', 'elementor-banner-sliders-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve banner-sliders widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-carousel-loop';
	}

	/**
	 * Register banner-sliders widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-banner-sliders-control' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'list_heading', [
				'label' => __( 'Heading', 'elementor-banner-sliders-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Heading' , 'elementor-banner-sliders-control' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'list_content', [
				'label' => __( 'Content', 'elementor-banner-sliders-control' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( 'List Content' , 'elementor-banner-sliders-control' ),
				'label_block' => true,
				'show_label' => false,
			]
		);
		$repeater->add_control(
			'list_button_text_1',
			[
				'label' => esc_html__( 'Button Text 1', 'elementor-banner-sliders-control' ),
				'label_block' => true,
				'placeholder' => __( 'Order Now', 'elementor-banner-sliders-control' ),
				'default' => __( 'Order Now' , 'elementor-banner-sliders-control' ),
				'type' => 'text',
			]
		);
		$repeater->add_control(
			'list_button_link_1',
			[
				'label' => esc_html__( 'Button Link 1', 'elementor-banner-sliders-control' ),
				'label_block' => true,
				'placeholder' => __( '#', 'elementor-banner-sliders-control' ),
				'default' => __( '#' , 'elementor-banner-sliders-control' ),
				'type' => 'text',
			]
		);
		$repeater->add_control(
			'list_button_text_2',
			[
				'label' => esc_html__( 'Button Text 2', 'elementor-banner-sliders-control' ),
				'label_block' => true,
				'placeholder' => __( 'Order Now', 'elementor-banner-sliders-control' ),
				'default' => __( 'Order Now' , 'elementor-banner-sliders-control' ),
				'type' => 'text',
			]
		);
		$repeater->add_control(
			'list_button_link_2',
			[
				'label' => esc_html__( 'Button Link 2', 'elementor-banner-sliders-control' ),
				'label_block' => true,
				'placeholder' => __( '#', 'elementor-banner-sliders-control' ),
				'default' => __( '#' , 'elementor-banner-sliders-control' ),
				'type' => 'text',
			]
		);
		$this->add_control(
			'list',
			[
				'label' => __( 'Repeater List', 'elementor-banner-sliders-control' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						
						'list_heading' => __( 'Heading', 'elementor-banner-sliders-control' ),
						'list_content' => __( 'Content', 'elementor-banner-sliders-control' ),
						'list_button_text_1' => __( 'Button Text 1', 'elementor-banner-sliders-control' ),
						'list_button_link_1' => __( '#', 'elementor-banner-sliders-control' ),
						'list_button_text_2' => __( 'Button Text 2', 'elementor-banner-sliders-control' ),
						'list_button_link_2' => __( '#', 'elementor-banner-sliders-control' ),
					],
					[
						
						'list_heading' => __( 'Heading', 'elementor-banner-sliders-control' ),
						'list_content' => __( 'Content', 'elementor-banner-sliders-control' ),
						'list_button_text_1' => __( 'Button Text 1', 'elementor-banner-sliders-control' ),
						'list_button_link_1' => __( '#', 'elementor-banner-sliders-control' ),
						'list_button_text_2' => __( 'Button Text 2', 'elementor-banner-sliders-control' ),
						'list_button_link_2' => __( '#', 'elementor-banner-sliders-control' ),
					],
				],
				'heading_field' => '{{{ list_heading }}}',
			]
		);
		$this->end_controls_section();
		//Color Control
		$this->start_controls_section(
			'color_section',
			[
				'label' => esc_html__( 'Color', 'elementor-testimonial-control' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'text_color1',
			[
				'label' => esc_html__( 'Title Color', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} h1' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
			'text_align1',
			[
				'label' => esc_html__( 'Alignment', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'elementor-testimonial-control' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'elementor-testimonial-control' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'elementor-testimonial-control' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} h1'   => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'text_color_content',
			[
				'label' => esc_html__( 'Content Color', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
			'text_align',
			[
				'label' => esc_html__( 'Alignment', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'elementor-testimonial-control' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'elementor-testimonial-control' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'elementor-testimonial-control' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} p'   => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
	}


	/**
	 * Render banner-sliders widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
		<section class="banner-con w-100 float-left d-table">
        <div class="d-table-cell align-middle">
            <div class="container">
                <div id="carouselBannerControls" class="carousel slide" data-ride="carousel">
                    <div class="carousel-inner">
						<?php
						$count = 0;
						if ( $settings['list'] ) {
						foreach ( $settings['list'] as $item ) {	
							?>
                        <div class="carousel-item <?php if($count==0){echo 'active';}?>">
							<div class="banner_content">
								<h1 class="text-white" data-aos="fade-up" data-aos-duration="600" data-aos-once="true"><?php echo $item['list_heading']; ?></h1>
								<p class="text-white" data-aos="fade-up" data-aos-duration="600" data-aos-once="true"><?php echo $item['list_content']; ?></p>
								<div class="banner-button" data-aos="fade-up" data-aos-duration="600" data-aos-once="true">
									<a class="button1 lets_talk text-decoration-none" href="<?php echo $item['list_button_link_1']; ?>"><?php echo $item['list_button_text_1']; ?><i class="circle fa-regular fa-angle-right"></i></a>
									<a class="lets_talk text-decoration-none" href="<?php echo $item['list_button_link_2']; ?>"><?php echo $item['list_button_text_2']; ?><i class="circle fa-regular fa-angle-right"></i></a>   
								</div> 
							</div>
                        </div>
						<?php
						$count++;
					}
					}
					?>
                    </div>
                    <a class="carousel-control-prev" href="#carouselBannerControls" role="button" data-slide="prev">
                        <span class="carousel-control-prev-icon" aria-hidden="true"><i
                                class="fas fa-angle-left d-flex align-items-center justify-content-center"></i></span>
                    </a>
                    <a class="carousel-control-next" href="#carouselBannerControls" role="button" data-slide="next">
                        <span class="carousel-control-next-icon" aria-hidden="true"><i
                                class="fas fa-angle-right d-flex align-items-center justify-content-center"></i></span>
                    </a>
                </div>
            </div>
        </div>
    </section>
        <?php
	}

}