<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor catering-service Widget.
 *
 * Elementor widget that uses the catering-service control.
 *
 * @since 1.0.0
 */
class Elementor_Catering_Service_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve catering-service widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'catering-service';
	}
	/**
	 * Get widget title.
	 *
	 * Retrieve catering-service widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Portfolio Slider', 'elementor-catering-service-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve catering-service widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-carousel-loop';
	}

	/**
	 * Register catering-service widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-services-box-control' ),
				'type' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'selected_style',
			[
				'label' => esc_html__( 'Select Style', 'elementor-services-post-control' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'style1', // Set the default style
				'options' => [
					'style1' => esc_html__( 'Style 1', 'elementor-services-post-control' ),
					'style2' => esc_html__( 'Style 2', 'elementor-services-post-control' ),
				],
			]
		);
		$this->add_control(
			'number_of_services_box',
			[
				'label' => __( 'Number of Services', 'elementor-services-box-control' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 9, // Set a default value
				'min' => 1,
				'max' => 210,
				'step' => 1,
			]
		);
		$this->add_control(
			'selected_icon',
			[
				'label' => esc_html__( 'Button Icon', 'elementor' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
			]
		);
		$this->add_control(
			'ai_button_text',
			[
				'label' => esc_html__( 'Button Text', 'elementor-immersive-button-control' ),
				'label_block' => true,
				'placeholder' => __( 'Read More', 'elementor-immersive-button-control' ),
				'type' => 'text',
			]
		);
		$this->add_responsive_control(
			'alignment',
			[
			'label' => esc_html__( 'Alignment', 'elementor-immersive-button-control' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'left' => [
					'title' => esc_html__( 'Left', 'elementor-immersive-button-control' ),
					'icon' => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'elementor-immersive-button-control' ),
					'icon' => 'eicon-text-align-center',
				],
				'right' => [
					'title' => esc_html__( 'Right', 'elementor-immersive-button-control' ),
					'icon' => 'eicon-text-align-right',
				],
			],
			'default' => 'left',
			'toggle' => true,
			'selectors' => [
			'{{WRAPPER}} .btn_wrapper_widget' => 'text-align: {{VALUE}};',
			],
			]
		);
        $this->end_controls_section();
		$this->start_controls_section(
			'title_style_section',
			[
				'label' => esc_html__( 'Title Style', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs(
			'style_tabs'
		);
		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'textdomain' ),
			]
		);
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Title Color', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio_image_box span' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography_button',
				'label' => __( 'Title Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .portfolio_image_box span',
			]
		);
        $this->add_control(
			'title_margin',
			[
				'label' => __( ' Title Margin', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .portfolio_image_box span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	
		$this->add_control(
			'title_padding',
			[
				'label' => __( 'Title Padding', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .portfolio_image_box span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'border_radius2',
			[
				'label' => __( 'Border Radius', 'elementor-our-work-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .portfolio_section .portfolio_image_box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background5',
				'label' => __( 'Background Color', 'textdomain' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .portfolio_section .portfolio_image_box',
            ]
        );
		$this->end_controls_tab();
		$this->start_controls_tab(
			'style_hover_tab',
				[
					'label' => esc_html__( 'Hover', 'textdomain' ),
				]
		);
		$this->add_control(
			'htitle_color',
			[
				'label' => esc_html__('Title Color', 'textdomain'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .portfolio_section .portfolio_image:hover .portfolio_image_box span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'hborder_radius2',
			[
				'label' => __( 'Border Radius', 'elementor-our-work-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .portfolio_section .portfolio_image:hover .portfolio_image_box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background9',
				'label' => __( 'Background Color', 'textdomain' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .portfolio_section .portfolio_image:hover .portfolio_image_box',
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		$this->start_controls_section(
			'desc_style_section',
			[
				'label' => esc_html__( 'Content Style', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs(
			'style_tabs1'
		);
		$this->start_controls_tab(
			'style_normal_tab1',
			[
				'label' => esc_html__( 'Normal', 'textdomain' ),
			]
		);
        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__('Text Color', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio_section .portfolio_box p' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'desc_typography_button',
				'label' => __( 'Text Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .portfolio_section .portfolio_box p',
			]
		);
        $this->add_control(
			'desc_margin',
			[
				'label' => __( ' Text Margin', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .portfolio_section .portfolio_box p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	
		$this->add_control(
			'desc_padding',
			[
				'label' => __( 'Text Padding', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .portfolio_section .portfolio_box p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'button_color',
            [
                'label' => esc_html__('Button Color', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio_section .portfolio_image .portfolio_box .btn_wrapper a' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography_button',
				'label' => __( 'Button Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .portfolio_section .portfolio_image .portfolio_box .btn_wrapper a',
			]
		);
        $this->add_control(
			'button_margin',
			[
				'label' => __( ' Button Margin', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .portfolio_section .portfolio_image .portfolio_box .btn_wrapper a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	
		$this->add_control(
			'button_padding',
			[
				'label' => __( 'Button Padding', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .portfolio_section .portfolio_image .portfolio_box .btn_wrapper a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'style_hover_tab2',
				[
					'label' => esc_html__( 'Hover', 'textdomain' ),
				]
		);
		$this->add_control(
            'hdesc_color',
            [
                'label' => esc_html__('Text Color', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio_section .portfolio_image:hover .portfolio_box p' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
            'hbutton_color',
            [
                'label' => esc_html__('Button Color', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio_section .portfolio_image:hover .portfolio_box .btn_wrapper a' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		$this->start_controls_section(
            'style_section3',
            [
                'label' => esc_html__( 'Button Styling', 'elementor-portfolio-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]

        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography_text',
				'label' => __( 'Text Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .btn_wrapper_widget a',
			]
		);
		$this->start_controls_tabs(
			'style_tabs3'
		);
		$this->start_controls_tab(
			'style_normal_tab3',
			[
				'label' => esc_html__( 'Normal', 'textdomain' ),
			]
		);
		$this->add_control(
            'button_text',
            [
                'label' => esc_html__( 'Button Text', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn_wrapper_widget a' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
			'button_background_color',
			[
				'label' => esc_html__( 'Button Background', 'elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .btn_wrapper_widget a' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
            'button_padding1',
            [
                'label' => esc_html__( 'Button Padding', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .btn_wrapper_widget a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->add_responsive_control(
			'button_radius1',
			[
				'label' => esc_html__( 'Button Radius', 'elementor' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .btn_wrapper_widget a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'icon_color',
            [
                'label' => esc_html__( 'Icon Color', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn_wrapper_widget i' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
			'icon_background_color',
			[
				'label' => esc_html__( 'Icon background', 'elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .btn_wrapper_widget i' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
            'icon_padding',
            [
                'label' => esc_html__( 'Icon Padding', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .btn_wrapper_widget i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->add_responsive_control(
			'icon_spacing',
			[
				'label' => esc_html__( 'Icon Spacing', 'elementor' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .btn_wrapper_widget i' => 'margin-left: {{SIZE}}{{UNIT}};',
				],
				'range' => [
					'em' => [
						'min' => 0,
						'max' => 5,
					],
				],
			]
		);
		$this->add_responsive_control(
			'rotate',
			[
				'label' => esc_html__( 'Icon Rotate', 'elementor' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'deg', 'grad', 'rad', 'turn', 'custom' ],
				'default' => [
					'unit' => 'deg',
				],
				'tablet_default' => [
					'unit' => 'deg',
				],
				'mobile_default' => [
					'unit' => 'deg',
				],
				'selectors' => [
					'{{WRAPPER}} .btn_wrapper_widget i, {{WRAPPER}} .elementor-icon svg' => 'transform: rotate({{SIZE}}{{UNIT}});',
				],
			]
		);
		$this->add_responsive_control(
			'icon_radius',
			[
				'label' => esc_html__( 'Icon Radius', 'elementor' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .btn_wrapper_widget i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
			
		$this->end_controls_tab();
			
		$this->start_controls_tab(
			'style_hover_tab3',
			[
				'label' => esc_html__( 'Hover', 'textdomain' ),
			]
		);
		$this->add_control(
            'button_text_hover',
            [
                'label' => esc_html__( 'Button Text', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn_wrapper_widget a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
			'button_background_color_hover',
			[
				'label' => esc_html__( 'Button Background', 'elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .btn_wrapper_widget a:hover' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
            'icon_color_hover',
            [
                'label' => esc_html__( 'Icon Color', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn_wrapper_widget a:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
			'icon_background_color_hover',
			[
				'label' => esc_html__( 'Icon background', 'elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .btn_wrapper_widget a:hover i' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();
			
		$this->end_controls_tabs();

		$this->end_controls_section();
		$this->start_controls_section(
            'image_section',
            [
                'label' => esc_html__( 'Image Style', 'elementor-services-box-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
		$this->add_control(
			'image_border_radius',
			[
				'label' => __( 'Image Border Radius', 'elementor-our-work-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .portfolio_section .portfolio_image figure img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
            'style4_section',
            [
                'label' => esc_html__( 'Box Style', 'elementor-services-box-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
		$this->add_responsive_control(
            'box_align',
            [
                'label' => esc_html__( 'Alignment', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'textdomain' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'textdomain' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'textdomain' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .portfolio_section .portfolio_box'   => 'text-align: {{VALUE}};',
                ],
            ]
        );
		$this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background1',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .portfolio_section .portfolio_box',
            ]
        );
        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__( 'Padding', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .portfolio_section .portfolio_box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->add_control(
			'content_margin',
			[
				'label' => __( 'Margin', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .portfolio_section .portfolio_box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_control(
			'border_radius1',
			[
				'label' => __( 'Border Radius', 'elementor-our-work-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .portfolio_section .portfolio_box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section();
		$this->start_controls_section(
            'dots_section',
            [
                'label' => esc_html__( 'Dots Style', 'elementor-services-box-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
		$this->add_control(
            'dots_color',
            [
                'label' => esc_html__('Active Color', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio_section .owl-carousel .owl-dots .owl-dot.active span' => 'background: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
            'dots_normal_color',
            [
                'label' => esc_html__('Default Color', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio_section .owl-carousel .owl-dots .owl-dot span' => 'background: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
			'custom_width1',
			[
				'label' => esc_html__('Normal Width', 'your-text-domain'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .portfolio_section .owl-carousel .owl-dots .owl-dot span' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'custom_width',
			[
				'label' => esc_html__('Active Custom Width', 'your-text-domain'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .portfolio_section .owl-carousel .owl-dots .owl-dot.active span' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'dots_border_radius',
			[
				'label' => __( 'Image Border Radius', 'elementor-our-work-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .portfolio_section .portfolio_image figure img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
	}
	/**
	 * Render catering-service widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$selected_style = $settings['selected_style'];
		$number_of_services_box = $settings['number_of_services_box'];
		$selected_icon = $settings['selected_icon']['value'];
		$button_text = $settings['ai_button_text'];
		$args = array(
			'post_type'      => 'our-portfolio',
			'orderby'        => 'ID',
			'post_status'    => 'publish',
			'order'          => 'ASC',
			'posts_per_page' => $number_of_services_box // this will retrieve all the posts that are published
		);
		$result = new WP_Query($args);
		?>
		<?php if ($selected_style === 'style1'){ ?>
		<section class="portfolio_section">
			<div class="row" data-aos="fade-up">
				<?php
				if ($result->have_posts()) {
					?>
					<div class="owl-carousel owl-theme">
						<?php
						while ($result->have_posts()) {
							$result->the_post();
							$meta = get_post_meta(get_the_ID(), 'post_thumbnail', true);
							?>
							<div class="item">
								<div class="portfolio_image">
									<a href="<?php echo get_post_permalink(); ?>">
										<figure class="mb-0"><img src="<?php echo $meta ?>" alt="" class="img-fluid"></figure>
									</a>
									<div class="portfolio_box">
										<?php 
											$content = get_the_content();
											$trimmed_content = wp_trim_words($content, 4, '');
										?>
										<a href="<?php echo get_post_permalink(); ?>"><p><?php echo $trimmed_content ?>.</p></a>
										<div class="btn_wrapper">
											<?php
												if (!empty($settings['selected_icon']['value']) && !empty($button_text)) {
													// User has set values, display them
													?>
													<div class="btn_wrapper_widget">
													<a href="<?php echo get_post_permalink(); ?>" class="text-decoration-none"><?php echo $settings['ai_button_text'] ?><i class="<?php echo $settings['selected_icon']['value'] ?>"></i></a>
													</div>
													<?php
												} else {
													// User hasn't set values, display the default text and icon
													?>
													<a href="<?php echo get_post_permalink(); ?>" class="text-decoration-none">Read More<i class="fa-solid fa-angle-right"></i></a>
													<?php
												} 
											?>
										</div>
									</div>
									<div class="portfolio_image_box">
										<span><?php echo get_the_title(); ?></span>
									</div>
								</div>
							</div>
							<?php
						}
						?>
					</div>
					<?php
				}
				?>
			</div>
		</section>
		<?php } elseif ($selected_style === 'style2'){
			echo '<div class="portfolio_section">';
		if ( $result-> have_posts() ) {
			
			?>
			<?php
				echo '<div class="row">';
				$count=0;
			while ( $result->have_posts() ){ 
				
				$result->the_post();
				$url = wp_get_attachment_url( get_post_thumbnail_id(), "post_thumbnail" );
				$meta = get_post_meta(get_the_ID(),'post_thumbnail', true);
				?>
                    <div class="col-lg-4 col-md-6 col-sm-6">
							<div class="portfolio_image">
							<a href="<?php echo get_post_permalink(); ?>">
								<figure class="mb-0"><img src="<?php echo $meta ?>" alt="" class="img-fluid"></figure>
							</a>
								<div class="portfolio_box">
									<?php 
										$content = get_the_content();
										$trimmed_content = wp_trim_words($content, 4, '');
									?>
									<a href="<?php echo get_post_permalink(); ?>"><p><?php echo $trimmed_content ?>.</p></a>
									<div class="btn_wrapper">
									<?php
										if (!empty($settings['selected_icon']['value']) && !empty($button_text)) {
											// User has set values, display them
											?>
											<div class="btn_wrapper_widget">
											<a href="<?php echo get_post_permalink(); ?>" class="text-decoration-none"><?php echo $settings['ai_button_text'] ?><i class="<?php echo $settings['selected_icon']['value'] ?>"></i></a>
											</div>
											<?php
										} else {
											// User hasn't set values, display the default text and icon
											?>
											<a href="<?php echo get_post_permalink(); ?>" class="text-decoration-none">Read More<i class="fa-solid fa-angle-right"></i></a>
											<?php
										} 
									?>
									</div>
								</div>
								<div class="portfolio_image_box">
									<span class="portfolio-post-title"><?php echo get_the_title(); ?></span>
								</div>
							</div>
						</div>
				<?php
        		$count++;
        		if ($count % 3 == 0) {
            	echo '</div><div class="row">';
        		}
				
            }   
			echo '</div>';
	    }
    
		echo '</div>';
		?>
		<?php
		}
	}
	

}
