<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor portfolio-post Widget.
 *
 * Elementor widget that uses the portfolio-post control.
 *
 * @since 1.0.0
 */
class Elementor_Portfolio_Post_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve portfolio-post widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'portfolio-post';
	}
	/**
	 * Get widget title.
	 *
	 * Retrieve portfolio-post widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Portfolio Post', 'elementor-portfolio-post-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve portfolio-post widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-posts-grid';
	}

	/**
	 * Register portfolio-post widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
        
        $this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-portfolio-post-control' ),
				'type' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'number_of_services_post',
			[
				'label' => __( 'Number of Projects', 'elementor-portfolio-post-control' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 6, // Set a default value
				'min' => 1,
				'max' => 21,
				'step' => 1,
			]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'color_section',
				[
					'label' => esc_html__( 'Color', 'elementor-portfolio-post-control' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'style_tabs'
			);
			$this->start_controls_tab(
				'style_normal_tab',
				[
					'label' => esc_html__( 'Normal', 'textdomain' ),
				]
			);


			$this->add_responsive_control(
				'image_padding',
				[
					'label' => esc_html__( 'Image Padding', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .portfolio_section .col-lg-4 .portfolio_image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'image_border',
				[
					'label' => esc_html__( 'Image Border', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .portfolio_section .col-lg-4 .portfolio_image figure img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'title_color',
				[
					'label'     => esc_html__( 'Title Color', 'elementor-portfolio-post-control' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .portfolio_section .col-lg-4 .portfolio-post-title' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'title_background_color',
				[
					'label' => esc_html__( 'Title Background Color', 'elementor' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .portfolio_section .col-lg-4 .portfolio_image_box' => 'background-color: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'tile padding',
				[
					'label' => esc_html__( 'Title Padding', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .portfolio_section .col-lg-4 .portfolio-post-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'background',
					'types' => [ 'classic', 'gradient', ],
					'selector' => '{{WRAPPER}} .portfolio_section .col-lg-4 .portfolio_box',
				]
			);
			$this->add_responsive_control(
				'box_margin',
				[
					'label' => esc_html__( 'Content Box Margin', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .portfolio_section .col-lg-4 .portfolio_box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'box_padding',
				[
					'label' => esc_html__( 'Content Box Padding', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .portfolio_section .col-lg-4 .portfolio_box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'Discription_color',
				[
					'label'     => esc_html__( 'Discription Color', 'elementor-portfolio-post-control' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .portfolio_section .col-lg-4 .portfolio_box p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'button_color',
				[
					'label' => __( 'Button Color', 'elementor-portfolio-post-control' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .portfolio_section .col-lg-4 .btn_wrapper a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->end_controls_tab();
				
			$this->start_controls_tab(
			'style_hover_tab',
				[
					'label' => esc_html__( 'Hover', 'textdomain' ),
				]
			);
			$this->add_control(
				'title_hover_color',
				[
					'label'     => esc_html__( 'Title Color', 'elementor-portfolio-post-control' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .portfolio_section .col-lg-4:hover .portfolio-post-title' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'title_hover_background_color',
				[
					'label' => esc_html__( 'Title Background Color', 'elementor' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .portfolio_section .col-lg-4:hover .portfolio_image_box' => 'background-color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'discription_hover_color',
				[
					'label'     => esc_html__( 'Discription Color', 'elementor-portfolio-post-control' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .portfolio_section .col-lg-4:hover .portfolio_box p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'button_hover_color',
				[
					'label' => __( 'Button Color', 'elementor-portfolio-post-control' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .portfolio_section .col-lg-4:hover .btn_wrapper a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'background2',
					'types' => [ 'classic', 'gradient', ],
					'selector' => '{{WRAPPER}} .portfolio_section .col-lg-4:hover .portfolio_box',
				]
			);
			$this->end_controls_tab();
				
			$this->end_controls_tabs();
          
			$this->end_controls_section();
			
	}
	/**
	 * Render portfolio-post widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$this->add_inline_editing_attributes( 'title_color', 'basic' );
		$this->add_render_attribute( 'title_color', 'class', 'elementor-heading-title' );
		$this->add_render_attribute( 'alignment', 'class', 'your-class' );
		$css = '';
		if ( ! empty( $settings['title_color'] ) ) {
    		$css .= '{{WRAPPER}} h4.elementor-heading-title { color: ' . $settings['title_color'] . '; }';
		}
		if ( ! empty( $settings['alignment'] ) ) {
    		$css .= '{{WRAPPER}} .your-class { text-align: ' . $settings['alignment'] . '; }';
		}
		if ( $css ) {
    		echo '<style>' . $css . '</style>';
		}
		$number_of_services_post = $settings['number_of_services_post'];
        ?>
        <?php
    	$args = array(
			'post_type' => 'our-portfolio',
			'orderby' => 'ID',
			'post_status' => 'publish',
			'order' => 'ASC',
			'posts_per_page' => $number_of_services_post,
		);	
		$result = new WP_Query( $args );
		echo '<div class="portfolio_section">';
		if ( $result-> have_posts() ) {
			
			?>
			<?php
				echo '<div class="row">';
				$count=0;
			while ( $result->have_posts() ){ 
				
				$result->the_post();
				$url = wp_get_attachment_url( get_post_thumbnail_id(), "post_thumbnail" );
				$meta = get_post_meta(get_the_ID(),'post_thumbnail', true);
				?>
               
                    <div class="col-lg-4 col-md-6 col-sm-6">
							<div class="portfolio_image">
							<a href="<?php echo get_post_permalink(); ?>">
								<figure class="mb-0"><img src="<?php echo $meta ?>" alt="" class="img-fluid"></figure>
							</a>
								<div class="portfolio_box">
									<?php 
										$content = get_the_content();
										$trimmed_content = wp_trim_words($content, 4, '');
									?>
									<a href="<?php echo get_post_permalink(); ?>"><p><?php echo $trimmed_content ?>.</p></a>
									<div class="btn_wrapper">
										<a href="<?php echo get_post_permalink(); ?>" class="text-decoration-none">Read More<i class="fa-solid fa-angle-right"></i></a>
									</div>
								</div>
								<div class="portfolio_image_box">
									<span class="portfolio-post-title"><?php echo get_the_title(); ?></span>
								</div>
							</div>
						</div>	
                
				<?php
        		$count++;
        		if ($count % 3 == 0) {
            	echo '</div><div class="row">';
        		}
				
            }   
			echo '</div>';
	    }
    
		echo '</div>';
		?>
    	
        <?php
		
	}

}
