<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor services-post Widget.
 *
 * Elementor widget that uses the services-post control.
 *
 * @since 1.0.0
 */
class Elementor_Services_Post_Widget extends \Elementor\Widget_Base {

	// public function __construct($data = [], $args = null) {
	// 	parent::__construct($data, $args);
	// 	$plugin_url = plugin_dir_url( __FILE__ );
	// 	wp_register_script( 'services-post',  $plugin_url . "assets/js/services-post.js", array( 'jquery' ), '', true );
	// }
	
	// public function get_script_depends() {
	// 	// Return an array of script handles that your widget depends on
	// 	return ['services-post'];
	// }
	

	/**
	 * Get widget name.
	 *
	 * Retrieve services-post widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'services-post';
	}
	/**
	 * Get widget title.
	 *
	 * Retrieve services-post widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Services Post', 'elementor-services-post-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve services-post widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-posts-grid';
	}


	/**
	 * Register services-post widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		
        
        $this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-services-post-control' ),
				'type' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'number_of_services_post',
			[
				'label' => __( 'Number of Projects', 'elementor-services-post-control' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 6, // Set a default value
				'min' => 1,
				'max' => 21,
				'step' => 1,
			]
			);
			$this->add_control(
				'selected_services',
				[
					'label' => esc_html__('Select Services', 'elementor-services-post-control'),
					'type' => \Elementor\Controls_Manager::SELECT2,
					'multiple' => true,
					'options' => $this->get_services_options(), // Define a function to get available services options
				]
			);
			$this->add_control(
				'selected_style',
				[
					'label' => esc_html__( 'Select Style', 'elementor-services-post-control' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'style1', // Set the default style
					'options' => [
						'style1' => esc_html__( 'Style 1', 'elementor-services-post-control' ),
						'style2' => esc_html__( 'Style 2', 'elementor-services-post-control' ),
						'style3' => esc_html__( 'Style 3', 'elementor-services-post-control' ),
						'style4' => esc_html__( 'Style 4', 'elementor-services-post-control' ),
					],
				]
			);			
			$this->add_control(
				'display_icon',
				[
					'label' => esc_html__( 'Display Button Icon', 'elementor-services-post-control' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Yes', 'elementor-services-post-control' ),
					'label_off' => esc_html__( 'No', 'elementor-services-post-control' ),
					'default' => 'yes', // Set the default value to 'yes' if you want the icon to be displayed by default.
				]
			);
			$this->add_control(
				'button_text',
				[
					'label' => esc_html__( 'Button Text', 'elementor-immersive-button-control' ),
					'label_block' => true,
					'placeholder' => __( 'Read More', 'elementor-immersive-button-control' ),
					'type' => 'text',
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'query_section',
				[
					'label' => esc_html__('Query Settings', 'your-text-domain'),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);
			
			$this->add_control(
				'orderby',
				[
					'label' => esc_html__('Order By', 'your-text-domain'),
					'type' => \Elementor\Controls_Manager::SELECT,
					'options' => [
						'ID' => esc_html__('Post ID', 'your-text-domain'),
						'title' => esc_html__('Title', 'your-text-domain'),
						'date' => esc_html__('Date', 'your-text-domain'),
						// Add other options as needed
					],
					'default' => 'ID', // Default order by Post ID
				]
			);
			
			$this->add_control(
				'post_status',
				[
					'label' => esc_html__('Post Status', 'your-text-domain'),
					'type' => \Elementor\Controls_Manager::SELECT,
					'options' => [
						'publish' => esc_html__('Publish', 'your-text-domain'),
						'draft' => esc_html__('Draft', 'your-text-domain'),
						// Add other options as needed
					],
					'default' => 'publish', // Default post status is 'publish'
				]
			);
			
			$this->add_control(
				'order',
				[
					'label' => esc_html__('Order', 'your-text-domain'),
					'type' => \Elementor\Controls_Manager::SELECT,
					'options' => [
						'ASC' => esc_html__('Ascending', 'your-text-domain'),
						'DESC' => esc_html__('Descending', 'your-text-domain'),
					],
					'default' => 'ASC', // Default order is ascending
				]
			);
			
			$this->end_controls_section();
			$this->start_controls_section(
				'settings_section',
				[
					'label' => esc_html__('Settings', 'elementor-services-slider-control'),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);
			$this->add_responsive_control(
				'services_post_space',
				[
					'label' => esc_html__( 'Spacing Between', 'services_post' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 50,
						],
					],
				]
			);
			$slides_to_show = range( 1, 5 );
			$slides_to_show = array_combine( $slides_to_show, $slides_to_show );
			$this->add_responsive_control(
				'services_slides_to_show',
				[
					'label' => esc_html__( 'Slides to Show', 'services_slides' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'options' => [
						'' => esc_html__( 'Default', 'services_slides' ),
					] + $slides_to_show,
					'default' => '3',
					
				]
			);
			$this->add_responsive_control(
				'services_show_nav',
				[
					'label' => esc_html__( 'Show Nav', 'services_slides_nav' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'options' => [
						'true' => esc_html__( 'Yes', 'services_slides' ),
						'false' => esc_html__( 'No', 'services_slides' ),
					],
					'default' => 'true',
				]
			);
			$this->add_responsive_control(
				'services_show_dots',
				[
					'label' => esc_html__( 'Show Dots', 'services_slides_dots' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'options' => [
						'true' => esc_html__( 'Yes', 'services_slides' ),
						'false' => esc_html__( 'No', 'services_slides' ),
					],
					'default' => 'true',
				]
			);
			$this->end_controls_section();

			$this->start_controls_section(
				'color_section',
				[
					'label' => esc_html__( 'Color', 'elementor-services-post-control' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->start_controls_tabs(
				'style_tabs'
			);
			$this->start_controls_tab(
				'style_normal_tab',
				[
					'label' => esc_html__( 'Normal', 'textdomain' ),
				]
			);
			$this->add_responsive_control(
				'image_padding',
				[
					'label' => esc_html__( 'Image Padding', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box figure' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'border_image',
					'label' => __( 'Image Border', 'textdomain' ),
					'selector' => '{{WRAPPER}} .services_section .services_box figure',
				]
			);
			
			$this->add_control(
				'border_color_img',
				[
					'label' => __( 'Border Color', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box figure' => 'border-color: {{VALUE}};',
					],
					'condition' => [
						'border!' => '',
					],
				]
			);
			$this->add_control(
				'title_color',
				[
					'label'     => esc_html__( 'Title Color', 'elementor-services-post-control' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box h5' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography_button',
					'label' => __( 'Title Typography', 'textdomain' ),
					'selector' => '{{WRAPPER}} .review-content .review-text',
				]
			);
			$this->add_responsive_control(
				'tile padding',
				[
					'label' => esc_html__( 'Title Padding', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__( 'Title Margin', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'background',
					'types' => [ 'classic', 'gradient', ],
					'selector' => '{{WRAPPER}} .services_section .services_box',
				]
			);
			$this->add_responsive_control(
				'box_margin',
				[
					'label' => esc_html__( 'Content Box Margin', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'box_padding',
				[
					'label' => esc_html__( 'Content Box Padding', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);
			$this->add_responsive_control(
				'content_padding',
				[
					'label' => esc_html__( 'Content padding', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box .inner-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);
			$this->add_control(
				'Discription_color',
				[
					'label'     => esc_html__( 'Discription Color', 'elementor-services-post-control' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'description_margin',
				[
					'label' => esc_html__( 'Discription Margin', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'desc_typography_button',
					'label' => __( 'Description Typography', 'textdomain' ),
					'selector' => '{{WRAPPER}} .services_section .services_box p',
				]
			);
			$this->add_control(
				'button_color',
				[
					'label' => __( 'Button Color', 'elementor-services-post-control' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box .btn_wrapper a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'typography_button',
					'label' => __( 'Button Typography', 'textdomain' ),
					'selector' => '{{WRAPPER}} .services_section .services_box .btn_wrapper a',
				]
			);
			$this->add_control(
				'button_color1',
				[
					'label' => esc_html__('Button Background Color', 'textdomain'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .btn_wrapper_widget a' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'button_margin',
				[
					'label' => __( ' Button Margin', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors' => [
						'{{WRAPPER}} .btn_wrapper_widget a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);
		
			$this->add_control(
				'button_padding',
				[
					'label' => __( 'Button Padding', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors' => [
						'{{WRAPPER}} .btn_wrapper_widget a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'button_radius1',
				[
					'label' => esc_html__( 'Button Radius', 'elementor' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .btn_wrapper_widget a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);
			$this->add_responsive_control(
				'box_align',
				[
					'label' => esc_html__( 'Alignment', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => esc_html__( 'Left', 'textdomain' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'textdomain' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'textdomain' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'default' => 'left',
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box'   => 'text-align: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'box_radius',
				[
					'label' => esc_html__( 'Box Radius', 'elementor' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'border1',
					'label' => __( 'Border', 'textdomain' ),
					'selector' => '{{WRAPPER}} .services_section .services_box',
				]
			);
			
			$this->add_control(
				'borde1r_color1',
				[
					'label' => __( 'Border Color', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box' => 'border-color: {{VALUE}};',
					],
					'condition' => [
						'border!' => '',
					],
				]
			);
			$this->add_responsive_control(
				'image_align',
				[
					'label' => esc_html__( 'Image Alignment', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'-webkit-left' => [
							'title' => esc_html__( 'Left', 'textdomain' ),
							'icon' => 'eicon-text-align-left',
						],
						'-webkit-center' => [
							'title' => esc_html__( 'Center', 'textdomain' ),
							'icon' => 'eicon-text-align-center',
						],
						'-webkit-right' => [
							'title' => esc_html__( 'Right', 'textdomain' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'default' => '-webkit-left',
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box'   => 'text-align: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'Image_padding',
				[
					'label' => esc_html__( 'Image Padding', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box figure img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'image_margin',
				[
					'label' => esc_html__( 'Margin', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box figure img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'iamge_margin',
				[
					'label' => esc_html__( 'Image Margin', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box figure' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);
			$this->add_control(
				'testimonial_z_index',
				[
					'label' => esc_html__('Z-Index', 'elementor-services-post-control'),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'default' => 1, // You can set a default value
					'min' => 1, // Set a minimum value
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box figure' => 'z-index: {{VALUE}};',
					],
				]
			);
			
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'backgroundIMAGE',
					'types' => [ 'classic', 'gradient', ],
					'selector' => '{{WRAPPER}} .services_section .services_box figure',
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'image_box_shadow',
					'exclude' => [
						'box_shadow_position',
					],
					'selector' => '{{WRAPPER}} figure',
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Css_Filter::get_type(),
				[
					'name' => 'css_filters',
					'selector' => '{{WRAPPER}} figure img',
				]
			);
			
			$this->end_controls_tab();
				
			$this->start_controls_tab(
			'style_hover_tab',
				[
					'label' => esc_html__( 'Hover', 'textdomain' ),
				]
			);
			$this->add_control(
				'title_hover_color',
				[
					'label'     => esc_html__( 'Title Color', 'elementor-services-post-control' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box:hover h5' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'discription_hover_color',
				[
					'label'     => esc_html__( 'Discription Color', 'elementor-services-post-control' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box:hover p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'button_hover_color',
				[
					'label' => __( 'Button Color', 'elementor-services-post-control' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box:hover .btn_wrapper a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'button_color_hover',
				[
					'label' => esc_html__('Button Background Color', 'textdomain'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box:hover .btn_wrapper a' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'background2',
					'types' => ['classic', 'gradient'],
					'selector' => '{{WRAPPER}} .services_section .services_box:hover',
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'border2',
					'label' => __( 'Border', 'textdomain' ),
					'selector' => '{{WRAPPER}} .services_section .services_box:hover',
				]
			);
			
			$this->add_control(
				'borde1r_color2',
				[
					'label' => __( 'Border Color', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box:hover' => 'border-color: {{VALUE}};',
					],
					'condition' => [
						'border!' => '',
					],
				]
			);
			$this->add_control(
				'transition_duration',
				[
					'label' => __('Transition Duration', 'your-text-domain'),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'selectors' => [
						'{{WRAPPER}} .services_section .services_box:hover' => 'transition-duration: {{SIZE}}ms;',
					],
					'condition' => [
						'background2_background' => 'gradient', // Adjust based on your needs
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'backgroundIMAGE1',
					'types' => [ 'classic', 'gradient', ],
					'selector' => '{{WRAPPER}} .services_section .services_box:hover figure',
					'label' => esc_html__( 'Image Background', 'elementor-services-post-control' ),
					'label_block' => true, // Set label_block to true
				]
			);			
			$this->end_controls_tab();
				
			$this->end_controls_tabs();
          
			$this->end_controls_section();
			$this->start_controls_section(
				'image_section',
				[
					'label' => esc_html__( 'Featured Image Styling', 'elementor-services-post-control' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			
			$this->add_responsive_control(
				'image_width',
				[
					'label' => esc_html__( 'Image Width', 'elementor-services-post-control' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'selectors' => [
						'{{WRAPPER}} .featured-image img' => 'width: {{SIZE}}{{UNIT}};',
					],
				]);
			
			$this->add_responsive_control(
				'image_height',
				[
					'label' => esc_html__( 'image Height', 'elementor-services-post-control' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'selectors' => [
						'{{WRAPPER}} .featured-image img' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'object-fit',
				[
					'label' => esc_html__( 'Object Fit', 'elementor-services-post-control' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'condition' => [
						'image_height[size]!' => '',
					],
					'options' => [
						'' => esc_html__( 'Default', 'elementor-services-post-control' ),
						'fill' => esc_html__( 'Fill', 'elementor-services-post-control' ),
						'cover' => esc_html__( 'Cover', 'elementor-services-post-control' ),
						'contain' => esc_html__( 'Contain', 'elementor-services-post-control' ),
					],
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .featured-image img' => 'object-fit: {{VALUE}};',
					],
				]
			);
	
			$this->add_responsive_control(
				'object-position',
				[
					'label' => esc_html__( 'Object Position', 'elementor-services-post-control' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'options' => [
						'center center' => esc_html__( 'Center Center', 'elementor-services-post-control' ),
						'center left' => esc_html__( 'Center Left', 'elementor-services-post-control' ),
						'center right' => esc_html__( 'Center Right', 'elementor-services-post-control' ),
						'top center' => esc_html__( 'Top Center', 'elementor-services-post-control' ),
						'top left' => esc_html__( 'Top Left', 'elementor-services-post-control' ),
						'top right' => esc_html__( 'Top Right', 'elementor-services-post-control' ),
						'bottom center' => esc_html__( 'Bottom Center', 'elementor-services-post-control' ),
						'bottom left' => esc_html__( 'Bottom Left', 'elementor-services-post-control' ),
						'bottom right' => esc_html__( 'Bottom Right', 'elementor-services-post-control' ),
					],
					'default' => 'center center',
					'selectors' => [
						'{{WRAPPER}} .featured-image img' => 'object-position: {{VALUE}};',
					],
					'condition' => [
						'object-fit' => 'cover',
					],
				]
			);
			$this->add_responsive_control(
				'featured_image_radius',
				[
					'label' => esc_html__( 'Border Radius', 'elementor' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .featured-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->end_controls_section();
			$this->start_controls_section(
				'dots_section',
				[
					'label' => esc_html__( 'Dots Style', 'elementor-services-box-control' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'dots_color',
				[
					'label' => esc_html__('Color', 'textdomain'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .owl-carousel .owl-dots .owl-dot.active span' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'custom_width1',
				[
					'label' => esc_html__('Normal Width', 'your-text-domain'),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => ['px', '%'],
					'selectors' => [
						'{{WRAPPER}} .owl-carousel .owl-dots .owl-dot span' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'custom_width',
				[
					'label' => esc_html__('Active Custom Width', 'your-text-domain'),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => ['px', '%'],
					'selectors' => [
						'{{WRAPPER}} .owl-carousel .owl-dots .owl-dot.active span' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'dots_normal_color',
				[
					'label' => esc_html__('Default Color', 'textdomain'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .owl-carousel .owl-dots .owl-dot span' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'testimonial_dots_align',
				[
					'label' => esc_html__('Dots Align', 'elementor-blog-post-control'),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'left',
					'options' => [
						'left' => 'Left',
						'center' => 'Center',
						'right' => 'Right',
						'justify' => 'Justify',
					],
					'selectors' => [
						'{{WRAPPER}} .owl-carousel .owl-dots' => 'text-align: {{VALUE}};',
					],
				]
			);
			
			$this->end_controls_section();
			
	}
	private function get_services_options() {
		$options = [];
		$args = array(
			'post_type' => 'services-post',
			'posts_per_page' => -1,
			'post_status' => 'publish',
		);
		$services = new WP_Query($args);
	
		if ($services->have_posts()) {
			while ($services->have_posts()) {
				$services->the_post();
				$options[get_the_ID()] = get_the_title();
			}
			wp_reset_postdata();
		}
	
		return $options;
	}
	
	/**
	 * Render services-post widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$selected_style = $settings['selected_style'];
		$button_text= $settings['button_text'];
		$this->add_inline_editing_attributes('title_color', 'basic');
		$this->add_render_attribute('title_color', 'class', 'elementor-heading-title');
		$this->add_render_attribute('alignment', 'class', 'your-class');
	
		$css = '';
	
		if (!empty($settings['title_color'])) {
			$css .= '{{WRAPPER}} h4.elementor-heading-title { color: ' . $settings['title_color'] . '; }';
		}
	
		if (!empty($settings['alignment'])) {
			$css .= '{{WRAPPER}} .your-class { text-align: ' . $settings['alignment'] . '; }';
		}
	
		if ($css) {
			// echo '<style>' . $css . '</style>';
		}
	
		$display_icon = $settings['display_icon'];
		$number_of_services_post = $settings['number_of_services_post'];
		$selected_services = $settings['selected_services'];
		$args = array(
			'post_type' => 'services-post',
			'orderby' => $this->get_settings('orderby'),
			'post_status' => $this->get_settings('post_status'),
			'order' => $this->get_settings('order'),
			'posts_per_page' => $number_of_services_post,
			'post__in' => $selected_services, // Include only the selected services
		);
	
		$result = new WP_Query($args);
	
		if ($selected_style === 'style1') {
			// Apply Style 1 styles
			echo '<div class="style1">';
			echo '<div class="services_section">';
	
			if ($result->have_posts()) {
				while ($result->have_posts()) {
					$result->the_post();
					$url = wp_get_attachment_url(get_post_thumbnail_id(), "post_thumbnail");
					$meta = get_post_meta(get_the_ID(), 'post_thumbnail', true);
					?>
					<div class="services_box">
						<figure class="mb-0">
							<img src="<?php echo $meta ?>" alt="" class="img-fluid">
						</figure>
						<h5><?php echo get_the_title(); ?></h5>
						<?php
						$content = get_the_content();
						$trimmed_content = wp_trim_words($content, 9, '');
						?>
						<p><?php echo $trimmed_content ?>..</p>
						<div class="btn_wrapper">
							<a href="<?php echo get_post_permalink(); ?>" class="text-decoration-none">Read More<?php if ($display_icon === 'yes') {
								echo '<i class="fa-solid fa-angle-right"></i>';
							} ?></a>
						</div>
					</div>
					<?php
				}
			}
	
			echo '</div>';
			echo '</div>';
		} elseif ($selected_style === 'style2') {
			echo '<div class="style2">';
	
			echo '<div class="services_section">';
			if ($result->have_posts()) {
				?>
				<div id="owl-demo" class="owl-carousel owl-theme">
				<?php
				while ($result->have_posts()) {
					$result->the_post();
					$url = wp_get_attachment_url(get_post_thumbnail_id(), "post_thumbnail");
					$meta = get_post_meta(get_the_ID(), 'post_thumbnail', true);
					?>
					<div class="item">
						<div class="services_box">
							<figure class="mb-0">
								<img src="<?php echo $meta ?>" alt="" class="img-fluid">
							</figure>
							<h5><?php echo get_the_title(); ?></h5>
							<?php
							$content = get_the_content();
							$trimmed_content = wp_trim_words($content, 9, '');
							?>
							<p><?php echo $trimmed_content ?>..</p>
							<div class="btn_wrapper">
								<?php
										if (!empty($button_text)) {
											// User has set values, display them
											?>
											<div class="btn_wrapper_widget">
											<a href="<?php echo get_post_permalink(); ?>" class="text-decoration-none"><?php echo $settings['button_text'] ?></a>
											</div>
											<?php
										} else {
											// User hasn't set values, display the default text and icon
											?>
											<a href="<?php echo get_post_permalink(); ?>" class="text-decoration-none">Read More<?php if ($display_icon === 'yes') {
												echo '<i class="fa-solid fa-angle-right"></i>';
											} ?></a>
											<?php
										} 
									?>
							</div>
						</div>
					</div>
					<?php
				}
				echo '</div>';
			}
			echo '</div>';
			echo '</div>';
		}
		elseif ($selected_style === 'style3') {
			echo '<div class="style2" id="services-style-3">';
	
			echo '<div class="services_section">';
			if ($result->have_posts()) {
				?>
				<div id="owl-demo" class="owl-carousel owl-theme">
				<?php
				while ($result->have_posts()) {
					$result->the_post();
					$url = wp_get_attachment_url(get_post_thumbnail_id(), "post_thumbnail");
					$meta = get_post_meta(get_the_ID(), 'post_thumbnail', true);
					?>
					<div class="item">
							<div class="services_box">
								<div class="featured-image">
									<img src="<?php echo wp_get_attachment_url( get_post_thumbnail_id(), "large" ) ?>">
								</div>
								<figure class="mb-0">
									<img src="<?php echo $meta ?>" alt="" class="img-fluid">
								</figure>
								<div class="inner-content">
									<h5><?php echo get_the_title(); ?></h5>
									<?php
									$content = get_the_content();
									$trimmed_content = wp_trim_words($content, 10, '');
									?>
									<p><?php echo $trimmed_content ?>..</p>
									<div class="btn_wrapper">
										<?php
												if (!empty($button_text)) {
													// User has set values, display them
													?>
													<div class="btn_wrapper_widget">
													<a href="<?php echo get_post_permalink(); ?>" class="text-decoration-none"><?php echo $settings['button_text'] ?></a>
													</div>
													<?php
												} else {
													// User hasn't set values, display the default text and icon
													?>
													<a href="<?php echo get_post_permalink(); ?>" class="text-decoration-none">Read More<?php if ($display_icon === 'yes') {
														echo '<i class="fa-solid fa-angle-right"></i>';
													} ?></a>
													<?php
												} 
											?>
									</div>
								</div>
								
							</div>
					</div>
					<?php
				}
				echo '</div>';
			}
			echo '</div>';
			echo '</div>';
		}
		elseif ($selected_style === 'style4') {
			echo '<div class="style5">';
			echo '<div class="style2" id="services-style-3">';
	
			echo '<div class="services_section">';
			if ($result->have_posts()) {
				?>
				<div id="owl-demo" class="owl-carousel owl-theme">
				<?php
				while ($result->have_posts()) {
					$result->the_post();
					$url = wp_get_attachment_url(get_post_thumbnail_id(), "post_thumbnail");
					$meta = get_post_meta(get_the_ID(), 'post_thumbnail', true);
					?>
					<div class="item">
							<div class="services_box">
								<div class="featured-image">
									<img src="<?php echo wp_get_attachment_url( get_post_thumbnail_id(), "large" ) ?>">
								</div>
								<div class="inner-content">
									<h5><?php echo get_the_title(); ?></h5>
									<?php
									$content = get_the_content();
									$trimmed_content = wp_trim_words($content, 10, '');
									?>
									<p><?php echo $trimmed_content ?>..</p>
									<div class="btn_wrapper">
										<?php
												if (!empty($button_text)) {
													// User has set values, display them
													?>
													<div class="btn_wrapper_widget">
													<a href="<?php echo get_post_permalink(); ?>" class="text-decoration-none"><?php echo $settings['button_text'] ?><i class="fas fa-arrow-right"></i></a>
													</div>
													<?php
												} else {
													// User hasn't set values, display the default text and icon
													?>
													<a href="<?php echo get_post_permalink(); ?>" class="text-decoration-none">Read More<?php if ($display_icon === 'yes') {
														echo '<i class="fa-solid fa-angle-right"></i>';
													} ?></a>
													<?php
												} 
											?>
									</div>
								</div>
								
							</div>
					</div>
					<?php
				}
				echo '</div>';
			}
			echo '</div>';
			echo '</div>';
			echo '</div>';
		}
		?>
		<script>
            var services_settings= <?php echo json_encode($settings); ?>;
			
        </script>
		<?php
	}
}	