<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor services-slider Widget.
 *
 * Elementor widget that uses the services-slider control.
 *
 * @since 1.0.0
 */
class Elementor_Services_Slider_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve services-slider widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'services-slider';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve services-slider widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'services Slider', 'elementor-services-slider-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve services-slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-carousel-loop';
	}

	/**
	 * Register services-slider widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
        
        $this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-services-slider-control' ),
				'type' => \Elementor\Controls_Manager::TAB_CONTENT,
				
			]
		);
		
		
		$slides_to_show = range( 1, 4 );
		$slides_to_show = array_combine( $slides_to_show, $slides_to_show );
		$this->add_responsive_control(
			'slides_to_show',
			[
				'label' => esc_html__( 'Slides to show', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'Default', 'elementor' ),
				] + $slides_to_show,
				'condition' => [
					'slides_to_show!' => '1',
				],
				'default' => 4,
				'frontend_available' => true,
			]
			);
		
	


		$this->end_controls_section();




        $this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Content', 'elementor-services-slider-control' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]

		);

		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Title Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .heading_title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
			'text_align',
			[
				'label' => esc_html__( 'Alignment', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'textdomain' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'textdomain' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'textdomain' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .heading_title'   => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'text_color1',
			[
				'label' => esc_html__( 'Text Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .heading_title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
			'margin',
			[
				'label' => esc_html__( 'Margin', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .heading_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'text_color2',
			[
				'label' => esc_html__( 'Text Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .content_color' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
			'padding',
			[
				'label' => esc_html__( 'Padding', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .content_color' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'content_align',
			[
				'label' => esc_html__( 'Alignment', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'textdomain' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'textdomain' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'textdomain' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .content_color'   => 'text-align: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .fa-arrow-right' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'border-radius',
			[
				'label' => esc_html__( 'Image Radius', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .img-fluid' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        
		$this->end_controls_section();

		$this->start_controls_section(
			'info_sectio',
			[
				'label' => esc_html__( 'Button Color', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .fa-arrow-right',
			]
		);
		$this->add_responsive_control(
			'icon_align',
			[
				'label' => esc_html__( 'Alignment', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'textdomain' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'textdomain' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'textdomain' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .btn_wrapper '   => 'text-align: {{VALUE}};',
				],
			]
		);
      
		$this->end_controls_section();



		
       

	}
   
    
    
			


	/**
	 * Render services-slider widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
	
		
        <?php
		//  var_dump($settings );
    $args = array(
		'post_type'=> 'services-post',
		'orderby'    => 'ID',
		'post_status' => 'publish',
		'order'    => 'ASC',
		'posts_per_page' => -1 // this will retrive all the post that is published 
		);
		
		$result = new WP_Query( $args );
		if ( $result-> have_posts() ) {
			?>
		<div id="owl-demo" class="owl-carousel owl-theme">
				<?php

					while ( $result->have_posts() ){ 
						
						
						$result->the_post();
						$url = wp_get_attachment_url( get_post_thumbnail_id(), "thumbnail" );
						?>
						<div class="item">
								<div class="services_box_content">
										<div class="services_box_lower_portion">
											<figure class="mb-0">
												<img src="<?php echo $url ?>" alt="" class="img-fluid">
												</figure>
												<h3 class="heading_title h4"><?php the_title(); ?></h3>
												<div class="content_color">
												<?php echo wp_trim_words( get_the_content(), 5 )?>
												</div>
												<div class="btn_wrapper">
												<a href="<?php echo get_post_permalink(); ?>" class="text-decoration-none"><i class="fas fa-arrow-right" aria-hidden="true"></i></a>
												</div>
										</div>
								</div>   
						</div>		
					<?php	
					}   	
				}
				?>
		</div>
		<script>
			var screen_to_show = '<?=$settings['slides_to_show'] ?>';
			var screen_to_show_laptop = '<?=$settings['slides_to_show_laptop'] ?>';
			var screen_to_show_tablet = '<?=$settings['slides_to_show_tablet'] ?>';
			

		</script>
    


    	
        <?php
		
	}

}

