<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 * Elementor testimonial-slider Widget.
 *
 * Elementor widget that uses the testimonial-slider control.
 *
 * @since 1.0.0
 */
class Elementor_Testimonial_Slider_Widget_2 extends \Elementor\Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve testimonial-slider widget name.
     *
     * @since 1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'testimonial-slider-2';
    }

    /**
     * Get widget title.
     *
     * Retrieve testimonial-slider widget title.
     *
     * @since 1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title()
    {
        return esc_html__('Testimonial Slider 2', 'elementor-testimonial-slider-control');
    }

    /**
     * Get widget icon.
     *
     * Retrieve testimonial-slider widget icon.
     *
     * @since 1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-carousel-loop';
    }

    /**
     * Register testimonial-slider widget controls.
     *
     * Add input fields to allow the user to customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'elementor-testimonial-slider-control'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'list_content',
            [
                'label' => __('Content', 'elementor-testimonial-slider-control'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => __('List Content', 'elementor-testimonial-slider-control'),
                'label_block' => true,
                'show_label' => false,
            ]
        );
        $repeater->add_control(
            'list_image',
            [
                'label' => __('Person Image', 'elementor-banner-slider-control'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => PLUGIN_BASE_URI . 'assets/images/quotation-icon-2.png',
                ],
            ]
        );
        $repeater->add_control(
            'list_image_2',
            [
                'label' => __('Icon Image', 'elementor-banner-slider-control'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => PLUGIN_BASE_URI . 'assets/img/testimonial_apostrophy_shape.png',
                ],
            ]
        );
        $repeater->add_control(
            'list_name',
            [
                'label' => __('Name', 'elementor-testimonial-slider-control'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Name', 'elementor-testimonial-slider-control'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'list_designation',
            [
                'label' => __('Designation', 'elementor-testimonial-slider-control'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Designation', 'elementor-testimonial-slider-control'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'list_rating',
            [
                'label' => __('Rating', 'elementor-testimonial-slider-control'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 5,
                'value' => 5,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'list',
            [
                'label' => __('Repeater List', 'elementor-testimonial-slider-control'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_rating' => __('5', 'elementor-testimonial-slider-control'),
                        'list_content' => __('Content', 'elementor-testimonial-slider-control'),
                        'list_image' => __('Media', 'elementor-banner-slider-control'),
                        'list_image_2' => __('Media', 'elementor-banner-slider-control'),
                        'list_name' => __('Name', 'elementor-testimonial-slider-control'),
                        'list_designation' => __('Designation', 'elementor-testimonial-slider-control'),
                    ],
                    [
                        'list_rating' => __('5', 'elementor-testimonial-slider-control'),
                        'list_content' => __('Content', 'elementor-testimonial-slider-control'),
                        'list_image' => __('Media', 'elementor-banner-slider-control'),
                        'list_image_2' => __('Media', 'elementor-banner-slider-control'),
                        'list_name' => __('Name', 'elementor-testimonial-slider-control'),
                        'list_designation' => __('Designation', 'elementor-testimonial-slider-control'),
                    ],
                ],
                'heading_name' => '{{{ list_name }}}',
            ]
        );
		$this->end_controls_section();

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Settings', 'elementor-testimonial-slider-control'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_responsive_control(
			'artelligence_testimonial_space',
			[
				'label' => esc_html__( 'Spacing Between', 'artelligence_testimonial' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
			]
		);
		$slides_to_show = range( 1, 5 );
		$slides_to_show = array_combine( $slides_to_show, $slides_to_show );
		$this->add_responsive_control(
			'artelligence_slides_to_show',
			[
				'label' => esc_html__( 'Slides to Show', 'artelligence_slides' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'Default', 'artelligence_slides' ),
				] + $slides_to_show,
				'default' => '2',
				
			]
		);
		$this->add_responsive_control(
			'artelligence_show_nav',
			[
				'label' => esc_html__( 'Show Nav', 'artelligence_slides_nav' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'true' => esc_html__( 'Yes', 'artelligence_slides' ),
					'false' => esc_html__( 'No', 'artelligence_slides' ),
				],
				'default' => 'false',
			]
		);
        $this->add_responsive_control(
			'artelligence_show_dots',
			[
				'label' => esc_html__( 'Show Dots', 'artelligence_slides_dots' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'true' => esc_html__( 'Yes', 'artelligence_slides' ),
					'false' => esc_html__( 'No', 'artelligence_slides' ),
				],
				'default' => 'true',
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'title_style_section',
			[
				'label' => esc_html__( 'Client Name Style', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Color', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .immersive-testimonial .designation-section h4' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography_button',
				'label' => __( 'Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .immersive-testimonial .designation-section h4',
			]
		);
        $this->add_control(
			'title_margin',
			[
				'label' => __( 'Margin', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .immersive-testimonial .designation-section h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	
		$this->add_control(
			'title_padding',
			[
				'label' => __( 'Padding', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .immersive-testimonial .designation-section h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'deig_style_section',
			[
				'label' => esc_html__( 'Client Designation Style', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
            'desig_color',
            [
                'label' => esc_html__('Color', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .immersive-testimonial .designation-section .ceo-text' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'desig_typography_button',
				'label' => __( 'Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .immersive-testimonial .designation-section .ceo-text',
			]
		);
        $this->add_control(
			'desig_margin',
			[
				'label' => __( 'Margin', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .immersive-testimonial .designation-section .ceo-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	
		$this->add_control(
			'desig_padding',
			[
				'label' => __( 'Padding', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .immersive-testimonial .designation-section .ceo-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'desc_style_section',
			[
				'label' => esc_html__( 'Text Style', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__('Text Color', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .review-content .review-text' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'desc_typography_button',
				'label' => __( 'Text Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .review-content .review-text',
			]
		);
        $this->add_control(
			'desc_margin',
			[
				'label' => __( ' Text Margin', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .review-content .review-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	
		$this->add_control(
			'desc_padding',
			[
				'label' => __( 'Text Padding', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .review-content .review-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
            'style4_section',
            [
                'label' => esc_html__( 'Box Style', 'elementor-services-box-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
		$this->add_responsive_control(
            'box_align',
            [
                'label' => esc_html__( 'Alignment', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'textdomain' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'textdomain' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'textdomain' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .immersive-testimonial'   => 'text-align: {{VALUE}};',
                ],
            ]
        );
		$this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background1',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .immersive-testimonial',
            ]
        );
        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__( 'Padding', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .immersive-testimonial' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->add_control(
			'content_margin',
			[
				'label' => __( 'Margin', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .immersive-testimonial' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'box_radius',
			[
				'label' => esc_html__( 'Box Radius', 'elementor' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .immersive-testimonial' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section();
		$this->start_controls_section(
            'style5_section',
            [
                'label' => esc_html__( 'Box Hover Style', 'elementor-services-box-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
		$this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background2',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .immersive-testimonial:hover',
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render testimonial-slider widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
    ?>
    <div class="artelligence-testimonial">

    
        <div id="immersive" class="owl-carousel  immersive-test owl-theme">
            <?php
            foreach ($settings['list'] as $item) {
            ?>
                <div class="immersive-testimonial">
                    <div class="designation-section">
                        <?php
                        if (isset($item['list_image']['id']) && !empty($item['list_image']['id'])) {
                        ?>
                            <figure class="testimonial-image">
                                <?php echo wp_get_attachment_image($item['list_image']['id'], 'full'); ?>
                            </figure>
                        <?php
                        } else {
                        ?>
                            <figure class="testimonial-image">
                                <img class="testimonial-image" src="<?php echo PLUGIN_BASE_URI . 'assets/images/mark-baucher-testimonial.jpg' ?>" alt="">
                            </figure>
                        <?php
                        }
                        ?>
                        <div class="testimonial-name">
                            <h4><?php echo $item['list_name'] ?></h4>
                            <small><span class="ceo-text"><?php echo $item['list_designation'] ?></span></small>
                        </div>
                        <?php
                        if (isset($item['list_image_2']['id']) && !empty($item['list_image_2']['id'])) {
                        ?>
                            <figure class="testimonial-icon">
                                <?php echo wp_get_attachment_image($item['list_image_2']['id'], 'full'); ?>
                            </figure>
                        <?php
                        } else {
                        ?>
                            <figure class="testimonial-icon">
                                <img class="testimonial-icon" src="<?php echo PLUGIN_BASE_URI . 'assets/images/testimonial_apostrophy_shape.png' ?>" alt="">
                            </figure>
                        <?php
                        }
                        ?>
                    </div>
                    <div class="review-content">
                        <div class="quote">
                            <p class="review-text"><span class="testimonial-quotation">“</span><?php echo strip_tags($item['list_content']) ?><span class="testimonial-quotation">”</span></p>
                        </div>
                    </div>
                </div>
            <?php
            }
            ?>
        </div>
        </div>
        <script>
            var testimonial_settings= <?php echo json_encode($settings); ?>;
        </script>
<?php
    }
}
