<?php
/**
 * artelligence functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package artelligence
 */
 
/**
 * Define Const for theme Dir
 * @since 1.0.0
 * */
define('ARTELLIGENCE_ROOT_PATH',get_template_directory());
define('ARTELLIGENCE_ROOT_URL',get_template_directory_uri());
define('ARTELLIGENCE_CSS',ARTELLIGENCE_ROOT_URL .'/assets/css');
define('ARTELLIGENCE_JS',ARTELLIGENCE_ROOT_URL .'/assets/js');
define('ARTELLIGENCE_IMG',ARTELLIGENCE_ROOT_URL .'/assets/img');
define('ARTELLIGENCE_INC',ARTELLIGENCE_ROOT_PATH .'/inc');
define('ARTELLIGENCE_THEME_STYLESHEETS',ARTELLIGENCE_INC .'/theme-stylesheets');

/**
 * define theme info
 * @since 1.0.0
 * */
if (is_child_theme()){
	$theme = wp_get_theme();
	$parent_theme = $theme->Template;
	$theme_info = wp_get_theme($parent_theme);
}else{
	$theme_info = wp_get_theme();
}
define('ARTELLIGENCE_DEV_MODE',true);
$gazania_version = ARTELLIGENCE_DEV_MODE ? time() : $theme_info->get('Version');
define('ARTELLIGENCE_NAME',$theme_info->get('Name'));
define('ARTELLIGENCE_VERSION',$gazania_version);
define('ARTELLIGENCE_AUTHOR',$theme_info->get('Author'));
define('ARTELLIGENCE_AUTHOR_URI',$theme_info->get('AuthorURI'));

/*
 * include template helper function
 * @since 1.0.0
 * */
if (file_exists(ARTELLIGENCE_INC.'/template-functions.php') && ARTELLIGENCE_INC.'/template-tags.php'){
	require_once  ARTELLIGENCE_INC.'/template-functions.php';
	require_once  ARTELLIGENCE_INC.'/template-tags.php';

	function Artelligence_Function($instance){
		$new_instance = false;
		switch ($instance){
			case ("Functions"):
				$new_instance = class_exists('Artelligence_Functions') ? Artelligence_Functions::getInstance() : false;
				break;
			case ("Tags"):
				$new_instance = class_exists('Artelligence_Tags') ? Artelligence_Tags::getInstance() : false;
				break;
			default:
				 $new_instance = false;
			break;
		}

		return $new_instance;
	}
}



/*
* Include theme init file
* @since 1.0.0
*/
if ( file_exists(ARTELLIGENCE_INC.'/class-artelligence-init.php' ) ) {
	require_once  ARTELLIGENCE_INC.'/class-artelligence-init.php';
}

if ( file_exists(ARTELLIGENCE_INC.'/plugins/tgma/activate.php') ) {
	require_once  ARTELLIGENCE_INC.'/plugins/tgma/activate.php';
}		

/**
 * Custom template helper function for this theme.
 */
require_once ARTELLIGENCE_INC . '/template-helper.php';
require_once ARTELLIGENCE_INC . '/artelligence_customizer.php';
require_once ARTELLIGENCE_INC . '/artelligence_customizer_data.php';



// Move comments textarea to bottom
function gazania_move_comment_field_to_bottom( $fields ) {
	$comment_field = $fields['comment'];
	unset( $fields['comment'] );
	$fields['comment'] = $comment_field;
	return $fields;
}
add_filter( 'comment_form_fields', 'gazania_move_comment_field_to_bottom' );


/**
 * Nav menu fallback function
 * @since 1.0.0
 */
 function artelligence_primary_menu_fallback()
{
    get_template_part('template-parts/default', 'menu');
}


function artelligence_block_editor_styles() {
	wp_enqueue_style( 'block-editor-bootstrap', get_theme_file_uri( 'assets/css/block-editor.bootstrap.css' ), array(), null );
	wp_enqueue_style( 'block-editor-theme', get_theme_file_uri( 'assets/css/block-editor.theme.css' ), array(), null );
}
add_action( 'enqueue_block_editor_assets', 'artelligence_block_editor_styles', 1, 1 );

/**
* admin js
**/
add_action('admin_enqueue_scripts', 'artelligence_admin_custom_scripts');
function artelligence_admin_custom_scripts(){
	wp_enqueue_media();
	wp_register_script('artelligence-admin-custom', get_template_directory_uri().'/inc/js/admin_custom.js', array('jquery'), '', true);
	wp_enqueue_script('artelligence-admin-custom');
}


/**
* shortcode supports for removing extra p, spance etc
*
*/
add_filter( 'the_content', 'artelligence_shortcode_extra_content_remove' );
/**
 * Filters the content to remove any extra paragraph or break tags
 * caused by shortcodes.
 *
 * @since 1.0.0
 *
 * @param string $content  String of HTML content.
 * @return string $content Amended string of HTML content.
 */
function artelligence_shortcode_extra_content_remove( $content ) {

    $array = array(
        '<p>['    => '[',
        ']</p>'   => ']',
        ']<br />' => ']'
    );
    return strtr( $content, $array );

}


/**
 * Nav menu fallback function
 * @since 1.0.0
 */
 function artelligence_theme_fallback_menu()
{
    get_template_part('template-parts/default', 'menu');
}


/**
 * Artelligence CSS Include
 */
function enqueue_our_required_stylesheet(){
	wp_enqueue_style('load-fa-pro', get_template_directory_uri(). '/assets/fonts/fontawesome-pro-v5.css');
	wp_enqueue_style('load-fa', get_template_directory_uri(). '/assets/fonts/fontawesome-v6.css');
	wp_enqueue_style('roboto-font', get_template_directory_uri() . '/assets/fonts/roboto.css' );
	wp_enqueue_style('artelligence-style-css', get_template_directory_uri() . '/assets/css/artelligence.css' ); 
	wp_enqueue_style('artelligence-responsive-css', get_template_directory_uri() . '/assets/css/artelligence-responsive.css' ); 
	wp_enqueue_style('owl-carousel-min', get_template_directory_uri() . '/assets/css/owl.carousel.min.css' ); 
	wp_enqueue_style('owl-carousel-min', get_template_directory_uri() . '/assets/css/owl.theme.default.min.css' ); 

}
add_action( 'wp_enqueue_scripts', 'enqueue_our_required_stylesheet' );


/**
 * Artelligence CSS Include In Footer
 */
function add_css_in_footer() {
	?>
	<link rel="stylesheet" href="<?php echo get_template_directory_uri() . '/assets/css/style.css'?>" type="text/css" media="all">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri() . '/assets/css/responsive.css'?>" type="text/css" media="all">
	<?php
}
add_action( 'wp_footer', 'add_css_in_footer', 100 );

function enqueue_theme_styles() {
	wp_register_style( 'header-style', ARTELLIGENCE_CSS . '/style.css', array(), time(), 'all' );
	wp_register_style( 'responsive', ARTELLIGENCE_CSS . '/responsive.css', array(), time(), 'all' );

	wp_enqueue_style( 'header-style' );
	wp_enqueue_style( 'responsive' );
}
add_action( 'wp_enqueue_scripts', 'enqueue_theme_styles' );
/**
 * Artelligence JS Include
 */
function enqueue_load_js() {
	if ( class_exists( 'RevSlider' ) ) {
        // Revolution Slider is active, don't enqueue the jQuery script
    } else {
        // Revolution Slider is not active, enqueue the jQuery script
        wp_enqueue_script( 'jquery-1.8.3', get_template_directory_uri() . '/assets/js/jquery-1.8.3.js', array(), '1.0.0', true );
    }
	wp_enqueue_script( 'slider-post', get_template_directory_uri() . '/assets/js/sliderpost.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'jquery.cycle.all', get_template_directory_uri() . '/assets/js/jquery.cycle.all.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'jquery.slicknav', get_template_directory_uri() . '/assets/js/jquery.slicknav.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'slider', get_template_directory_uri() . '/assets/js/slider.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'custom.min', get_template_directory_uri() . '/assets/js/jquery-ui-1.9.2.custom.min.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'effects.core', get_template_directory_uri() . '/assets/js/jquery.effects.core.min.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'scripts', get_template_directory_uri() . '/assets/js/scripts.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'custom-js', get_template_directory_uri() . '/assets/js/custom.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'owl-carousel-js', get_template_directory_uri() . '/assets/js/owl.carousel.js', array( 'jquery' ), '', true ); 
	wp_enqueue_script( 'owl-carousel-min-js', get_template_directory_uri() . '/assets/js/owl.carousel.min.js', array( 'jquery' ), '', true ); 
	wp_localize_script( 'custom', 'ArtelligenceAjax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ),'HOME_URL'=> home_url() ));  
}
add_action( 'wp_enqueue_scripts', 'enqueue_load_js' );





/**
 * Function For Elementor Global Colors after import.
 */
add_action('akd_elementor_global', 'artelligence_elementor_global_setup');
function artelligence_elementor_global_setup()
{
    $artelligence_elementor_kit = apply_filters('artelligence_elementor_global', false);
    if ($artelligence_elementor_kit)
    {
        esc_attr($artelligence_elementor_kit);
    }
}

/**
 * Get Elementor Template list
 */
function artelligence_get_elementor_templates()
{
    $args = array(
        'post_type' => 'elementor_library',
        'post_status' => 'publish',
    );
    $artelligence_the_query = new WP_Query($args);
    $artelligence_elementor_posts = array();
    if ($artelligence_the_query->have_posts()):
        foreach ($artelligence_the_query->posts as $artelligence_post):
            $artelligence_elementor_posts[$artelligence_post->ID] = apply_filters('the_title', get_the_title($artelligence_post));
        endforeach;
    endif;
    return $artelligence_elementor_posts;
}


// Add product title in Woocoomerce single product
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );
function woocommerce_template_single_title_custom()
{
    the_title( '<h3 class="product_title entry-title">',' </h3>' );
}
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title_custom', 5);

/**
 * Get Elementor Template list
 */


 function artelligence_get_elementor_header_templates()
 {	
	 $args = array(
		 'post_type' => 'elementor_library',
		 'posts_per_page' => -1,
		 'tax_query' => array(
			 array(
				 'taxonomy' => 'elementor_library_category',
				 'field' => 'slug',
				 'terms' => 'header',
			 ),
		 ),
	 );
	 
	 $query = new WP_Query( $args );
	 $artelligence_header_templates = array();
	 if ( $query->have_posts() ) {
		 foreach ($query->posts as $artelligence_post):
			 $artelligence_header_templates[$artelligence_post->ID] = apply_filters('the_title', get_the_title($artelligence_post));
		 endforeach;
	 }
	 return $artelligence_header_templates;	
 }

 function enqueue_owl_carousel_assets_for_elementor() {
    if ( defined( 'ELEMENTOR_PATH' ) && \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
        wp_enqueue_style( 'owl-carousel-min', get_template_directory_uri() . '/assets/css/owl.carousel.min.css' );
        wp_enqueue_style( 'owl-carousel-theme-default', get_template_directory_uri() . '/assets/css/owl.theme.default.min.css' );
        wp_enqueue_script( 'owl-carousel-js', get_template_directory_uri() . '/assets/js/owl.carousel.js', array( 'jquery' ), '', true );
		// Enqueue plugin-related scripts
		$plugin_url = plugin_dir_url( __FILE__ );
		wp_enqueue_script( 'artelligence_JS',  $plugin_url . "assets/js/artelligence.js", array( 'jquery' ), '', true );
		wp_enqueue_script( 'services-post',  $plugin_url . "assets/js/services-post.js", array( 'jquery' ), '', true );
    }
}

add_action( 'wp_enqueue_scripts', 'enqueue_owl_carousel_assets_for_elementor' );

